/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.AMXConfigHelper;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class MonitoringHandlers {
    private static final List<String> levels = new ArrayList<String>();

    public static void getMonitorLevels(HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        ArrayList result = new ArrayList();
        try {
            AMXConfigProxy amx = (AMXConfigProxy)V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectName));
            AMXConfigHelper helper = new AMXConfigHelper(amx);
            Map attrs = helper.simpleAttributesMap();
            for (String oneMonComp : attrs.keySet()) {
                if (oneMonComp.equals("Parent") || oneMonComp.equals("Children") || oneMonComp.equals("Name")) continue;
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("monCompName", oneMonComp);
                oneRow.put("level", attrs.get(oneMonComp));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        handlerCtx.setOutputValue("monitorCompList", result);
    }

    public static void getStatsbyTypeName(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        Locale locale = GuiUtil.getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        ArrayList result = new ArrayList();
        try {
            Query query = V3AMX.getInstance().getDomainRoot().getQueryMgr();
            Set amxproxy = query.queryTypeName(type, name);
            Iterator iter = amxproxy.iterator();
            while (iter.hasNext()) {
                Map monattrs = ((AMXProxy)iter.next()).attributesMap();
                for (String monName : monattrs.keySet()) {
                    if (monName.equals("Parent") || monName.equals("Children") || monName.equals("Name")) continue;
                    HashMap<String, Object> statMap = new HashMap<String, Object>();
                    Object val = monattrs.get(monName);
                    String details = "--";
                    String desc = "--";
                    String start = "--";
                    String last = "--";
                    String unit = "";
                    String current = "";
                    if (val instanceof CompositeDataSupport) {
                        CompositeDataSupport cds = (CompositeDataSupport)val;
                        statMap.put("Name", cds.get("name"));
                        CompositeType ctype = cds.getCompositeType();
                        if (cds.containsKey("unit")) {
                            unit = (String)cds.get("unit");
                        }
                        if (cds.containsKey("description")) {
                            desc = (String)cds.get("description");
                        }
                        if (cds.containsKey("startTime")) {
                            start = df.format(new Date((Long)cds.get("startTime")));
                        }
                        if (cds.containsKey("lastSampleTime")) {
                            last = df.format(new Date((Long)cds.get("lastSampleTime")));
                        }
                        if (cds.containsKey("maxTime")) {
                            details = GuiUtil.getMessage((String)"monitoring.MaxTime") + ": " + cds.get("maxTime") + " " + unit + "<br/>";
                        }
                        if (cds.containsKey("minTime")) {
                            details = details + GuiUtil.getMessage((String)"monitoring.MinTime") + ": " + cds.get("minTime") + " " + unit + "<br/>";
                        }
                        if (cds.containsKey("totalTime")) {
                            details = details + GuiUtil.getMessage((String)"monitoring.TotalTime") + ": " + cds.get("totalTime") + " " + unit + "<br/>";
                        }
                        val = cds.containsKey("count") ? cds.get("count") + " " + unit : (cds.containsKey("current") ? cds.get("current") : "--");
                    } else if (val instanceof String[]) {
                        statMap.put("Name", monName);
                        String values = "";
                        for (String s : (String[])val) {
                            values = values + s + "<br/>";
                        }
                        val = values;
                    } else {
                        statMap.put("Name", monName);
                    }
                    statMap.put("Current", current);
                    statMap.put("StartTime", start);
                    statMap.put("LastTime", last);
                    statMap.put("Description", desc);
                    statMap.put("Value", val);
                    statMap.put("Details", details);
                    result.add(statMap);
                }
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void updateMonitorLevels(HandlerContext handlerCtx) {
        String objectNameStr = (String)handlerCtx.getInputValue("objectName");
        List allRows = (List)handlerCtx.getInputValue("allRows");
        for (Map oneRow : allRows) {
            V3AMX.setAttribute((String)objectNameStr, (Attribute)new Attribute((String)oneRow.get("monCompName"), oneRow.get("level")));
        }
    }

    public static void getValidMonitorLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("monitorLevelList", levels);
    }

    public static void getFirstValueFromList(HandlerContext handlerCtx) {
        List values = (List)handlerCtx.getInputValue("values");
        String firstval = "";
        if (values != null && values.size() != 0) {
            firstval = (String)values.get(0);
        }
        handlerCtx.setOutputValue("firstValue", (Object)firstval);
    }

    static {
        levels.add("OFF");
        levels.add("LOW");
        levels.add("HIGH");
    }
}

