/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.logger.FileLoggerHandler;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.admin.config.Property;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualServer
extends StandardHost {
    private static final String STATE = "state";
    private static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    private static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    private static final String SSO_COOKIE_SECURE = "sso-cookie-secure";
    private static final String DISABLED = "disabled";
    private static final String OFF = "off";
    private static final String ON = "on";
    private VirtualServerPipeline vsPipeline;
    private Pipeline origPipeline = this.pipeline;
    private String _id = null;
    protected static final Logger _logger = LogDomains.getLogger(VirtualServer.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle rb = _logger.getResourceBundle();
    protected boolean _debug = false;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = false;
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;
    private String[] cacheControls;
    private boolean isActive;
    private String authRealmName;
    private PEAccessLogValve accessLogValve;
    private String ssoCookieSecure = null;
    private String defaultContextPath = null;

    public VirtualServer() {
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this.accessLogValve.setContainer((Container)this);
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public String getInfo() {
        return _info;
    }

    public void setDefaultContextPath(String defaultContextPath) {
        this.defaultContextPath = defaultContextPath;
    }

    public Container findChild(String contextRoot) {
        if (this.defaultContextPath != null && "/".equals(contextRoot)) {
            return super.findChild(this.defaultContextPath);
        }
        return super.findChild(contextRoot);
    }

    public void configureSingleSignOnCookieSecure(Cookie ssoCookie, HttpServletRequest hreq) {
        super.configureSingleSignOnCookieSecure(ssoCookie, hreq);
        if (this.ssoCookieSecure != null && !this.ssoCookieSecure.equals("dynamic")) {
            ssoCookie.setSecure(Boolean.parseBoolean(this.ssoCookieSecure));
        }
    }

    public synchronized void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    protected String getDefaultContextPath(Domain domain, ApplicationRegistry appRegistry) {
        Applications appsBean;
        WebModuleConfig wmInfo;
        String contextRoot = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null && (contextRoot = (wmInfo = this.findWebModuleInJ2eeApp(appsBean = domain.getApplications(), wmID, appRegistry)) == null ? ConfigBeansUtilities.getContextRoot((String)wmID) : wmInfo.getContextPath()) == null) {
            Object[] params = new Object[]{wmID, this.getID()};
            _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
        }
        return contextRoot;
    }

    protected WebModuleConfig getDefaultWebModule(Domain domain, WebArchivist webArchivist, ApplicationRegistry appRegistry) {
        WebModuleConfig wmInfo = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            Applications appsBean = domain.getApplications();
            wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID, appRegistry);
            if (wmInfo == null) {
                String contextRoot = ConfigBeansUtilities.getContextRoot((String)wmID);
                String location = ConfigBeansUtilities.getLocation((String)wmID);
                if (contextRoot != null && location != null) {
                    File docroot = new File(location);
                    WebBundleDescriptor wbd = webArchivist.getDefaultWebXmlBundleDescriptor();
                    wmInfo = new WebModuleConfig();
                    wbd.setName("__default-web-module");
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setLocation(docroot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    wmInfo.setAppClassLoader((ClassLoader)new WebappClassLoader(wmInfo.getParentLoader()));
                }
            }
            if (wmInfo == null) {
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", new Object[]{wmID, this.getID()});
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary(WebArchivist webArchivist) {
        WebModuleConfig wmInfo = null;
        String docroot = this.getAppBase();
        if (this.getDefaultWebModuleID() == null && this.findChild("") == null && docroot != null) {
            WebBundleDescriptor wbd = webArchivist.getDefaultWebXmlBundleDescriptor();
            wmInfo = new WebModuleConfig();
            wbd.setModuleID("__default-web-module");
            wbd.setContextRoot("");
            wmInfo.setLocation(new File(docroot));
            wmInfo.setDescriptor(wbd);
            wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
            WebappClassLoader loader = new WebappClassLoader(wmInfo.getParentLoader());
            loader.start();
            wmInfo.setAppClassLoader((ClassLoader)loader);
            if (wbd.getApplication() == null) {
                Application application = new Application(Globals.getDefaultHabitat());
                application.setVirtual(true);
                application.setName("__default-web-module");
                wbd.setApplication(application);
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig loadWebModuleConfig(WebModule wm) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        return wmInfo;
    }

    private boolean isActive(WebModule wm) {
        return this.isActive(wm, true);
    }

    protected boolean isActive(WebModule wm, boolean matchVSID) {
        String vsID = this.getID();
        boolean active = vsID != null && vsID.length() > 0;
        if (active &= wm != null) {
            List vsList;
            active &= Boolean.valueOf(wm.getEnabled()).booleanValue();
            String vsIDs = this.getVirtualServers(wm.getName());
            if (this.getID().equals("__asadmin") && matchVSID && (vsIDs == null || vsIDs.length() == 0)) {
                return false;
            }
            active = matchVSID && vsIDs != null && vsIDs.length() > 0 ? ((vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,")) != null ? (active &= vsList.contains(vsID.trim())) : (active &= true)) : (active &= true);
        }
        return active;
    }

    protected String getDefaultWebModuleID() {
        String wmID = this.vsBean.getDefaultWebModule();
        if (wmID != null && wmID.equals("")) {
            wmID = null;
        }
        if (wmID != null && this._debug) {
            Object[] params = new Object[]{wmID, this._id};
            _logger.log(Level.FINE, "vs.defaultWebModule", params);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id, ApplicationRegistry appRegistry) {
        WebModuleConfig wmInfo = null;
        int length = id.length();
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            separatorIndex = id.indexOf(35);
        }
        if (separatorIndex != -1) {
            String appID = id.substring(0, separatorIndex);
            String moduleID = id.substring(separatorIndex + 1);
            com.sun.enterprise.config.serverbeans.Application appBean = (com.sun.enterprise.config.serverbeans.Application)appsBean.getModule(com.sun.enterprise.config.serverbeans.Application.class, appID);
            if (appBean != null && Boolean.valueOf(appBean.getEnabled()).booleanValue()) {
                String location = appBean.getLocation();
                String moduleDir = DeploymentUtils.getRelativeEmbeddedModulePath((String)location, (String)moduleID);
                ApplicationInfo appInfo = appRegistry.get(appID);
                Application app = null;
                if (appInfo == null) {
                    Object[] params = new Object[]{id, this.getID()};
                    _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
                    return wmInfo;
                }
                app = (Application)appInfo.getMetaData(Application.class);
                WebBundleDescriptor wbd = app.getWebBundleDescriptorByUri(moduleID);
                String webUri = wbd.getModuleDescriptor().getArchiveUri();
                String contextRoot = wbd.getModuleDescriptor().getContextRoot();
                if (moduleID.equals(webUri)) {
                    StringBuffer dir = new StringBuffer(location);
                    dir.append(File.separator);
                    dir.append(moduleDir);
                    File docroot = new File(dir.toString());
                    wmInfo = new WebModuleConfig();
                    wbd.setName(moduleID);
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setLocation(docroot);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    wmInfo.setAppClassLoader((ClassLoader)new WebappClassLoader(wmInfo.getParentLoader()));
                }
            } else {
                Object[] params = new Object[]{id, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
            }
        }
        return wmInfo;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        Server server = (Server)Globals.getDefaultHabitat().getComponent(Server.class);
        for (ApplicationRef appRef : server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef.getVirtualServers();
        }
        return ret;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    List<Property> getProperties() {
        return this.vsBean.getProperty();
    }

    public void configure(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap, String logServiceFile, String logLevel, FileLoggerHandler logHandler) {
        this.setDebug(this.debug);
        this.setAppBase(vsDocroot);
        this.setName(vsID);
        this.setID(vsID);
        this.setBean(vsBean);
        this.setMimeMap(vsMimeMap);
        String defaultContextXmlLocation = "config/context.xml";
        String defaultWebXmlLocation = "config/default-web.xml";
        Property prop = vsBean.getProperty("default-web-xml");
        if (prop != null) {
            defaultWebXmlLocation = prop.getValue();
        }
        boolean allowLinking = false;
        prop = vsBean.getProperty("allowLinking");
        if (prop != null) {
            allowLinking = Boolean.parseBoolean(prop.getValue());
        }
        this.setAllowLinking(allowLinking);
        prop = vsBean.getProperty("contextXmlDefault");
        if (prop != null) {
            defaultContextXmlLocation = prop.getValue();
        }
        this.setDefaultWebXmlLocation(defaultWebXmlLocation);
        this.setDefaultContextXmlLocation(defaultContextXmlLocation);
        String state = vsBean.getState();
        if (state == null) {
            state = ON;
        }
        if (DISABLED.equalsIgnoreCase(state)) {
            this.setIsActive(false);
        } else {
            this.setIsActive(Boolean.parseBoolean(state));
        }
        if (vsLogFile != null && !vsLogFile.equals(logServiceFile)) {
            this.setLogFile(vsLogFile, logLevel, logHandler);
        }
    }

    protected void configureCatalinaProperties() {
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            }
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.valueOf(propValue));
        }
    }

    void setLogFile(String logFile, String logLevel, FileLoggerHandler logHandler) {
        logHandler.setLogFile(logFile);
        logHandler.setLevel(logLevel);
    }

    void configureAliases() {
        List hosts = StringUtils.parseStringList((String)this.vsBean.getHosts(), (String)",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost") || alias.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(alias);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
        List properties = this.vsBean.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property p : properties) {
                if (p == null || !"authRealm".equals(p.getName())) continue;
                this.authRealmName = p.getValue();
                if (this.authRealmName == null) break;
                AuthRealm realm = null;
                List rs = securityService.getAuthRealm();
                if (rs != null && rs.size() > 0) {
                    for (AuthRealm r : rs) {
                        if (r == null || !r.getName().equals(this.authRealmName)) continue;
                        realm = r;
                        break;
                    }
                }
                if (realm != null) break;
                _logger.log(Level.SEVERE, "vs.invalidAuthRealm", new Object[]{this.getID(), this.authRealmName});
                break;
            }
        }
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Object valve = this.loadInstance(valveName);
        if (valve instanceof Valve) {
            this.addValve((Valve)valve);
        } else if (valve instanceof GlassFishValve) {
            this.addValve((GlassFishValve)valve);
        } else {
            _logger.log(Level.WARNING, "Object of type classname " + valveName + " not an instance of Valve or GlassFishValve");
        }
    }

    protected void addListener(String listenerName) {
        Object listener = this.loadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            _logger.log(Level.SEVERE, "vs.invalidListener", new Object[]{listenerName, this.getID()});
        }
    }

    private Object loadInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "webcontainer.unableToLoadExtension", ex);
            return null;
        }
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.sendErrorMissingPath", propValue);
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingFrom", propValue);
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingUrlOrUrlPrefix", propValue);
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectBothUrlAndUrlPrefix", propValue);
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    _logger.log(Level.WARNING, "webcontainer.redirectInvalidEscape", propValue);
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline((Pipeline)this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSingleSignOn(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory) {
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Disabling Single Sign On (SSO) for virtual server " + this.getID() + ", as configured");
            }
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
        } else {
            Property expireTime;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Enabling Single Sign On (SSO) for virtual server " + this.getID() + ", as configured");
            }
            SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
            GlassFishSingleSignOn sso = ssoFactory.createSingleSignOnValve(this.getName());
            Property idle = this.vsBean.getProperty(SSO_MAX_IDLE);
            if (idle != null && idle.getValue() != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("SSO entry max idle time set to: " + idle.getValue() + " for virtual server " + this.getID());
                }
                sso.setMaxInactive(Integer.parseInt(idle.getValue()));
            }
            if ((expireTime = this.vsBean.getProperty(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("SSO expire thread interval set to: " + expireTime.getValue() + " for virtual server " + this.getID());
                }
                sso.setReapInterval(Integer.parseInt(expireTime.getValue()));
            }
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)sso);
            this.configureSingleSignOnCookieSecure();
        }
    }

    void configureState() {
        String stateValue = this.vsBean.getState();
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase("__asadmin")) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!ConfigBeansUtilities.toBoolean((String)stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        RemoteAddrValve remoteAddrValve = null;
        Property allow = this.vsBean.getProperty("allowRemoteAddress");
        Property deny = this.vsBean.getProperty("denyRemoteAddress");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            remoteAddrValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            remoteAddrValve.setDeny(deny.getValue());
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve() {
        RemoteHostValve remoteHostValve = null;
        Property allow = this.vsBean.getProperty("allowRemoteHost");
        Property deny = this.vsBean.getProperty("denyRemoteHost");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            remoteHostValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            remoteHostValve.setDeny(deny.getValue());
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteHostValve);
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, Habitat habitat, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, habitat, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve((GlassFishValve)this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
            }
        }
    }

    void disableAccessLogging() {
        this.removeValve((GlassFishValve)this.accessLogValve);
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
            this.setCacheControls(values.toArray(new String[values.size()]));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        String ssoEnabled = this.vsBean.getSsoEnabled();
        return "inherit".equals(ssoEnabled) && globalSSOEnabled || ConfigBeansUtilities.toBoolean((String)ssoEnabled);
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        String enabled = this.vsBean.getAccessLoggingEnabled();
        return "inherit".equals(enabled) && globalAccessLoggingEnabled || ConfigBeansUtilities.toBoolean((String)enabled);
    }

    public void setRealm(Realm realm) {
        if (realm != null && !(realm instanceof RealmAdapter)) {
            _logger.log(Level.SEVERE, "Realm " + realm.getClass().getName() + " not an instance of " + RealmAdapter.class.getName() + ", and will be ignored");
        } else {
            super.setRealm(realm);
        }
    }

    private void configureSingleSignOnCookieSecure() {
        String cookieSecure = this.vsBean.getSsoCookieSecure();
        if (!("true".equalsIgnoreCase(cookieSecure) || "false".equalsIgnoreCase(cookieSecure) || cookieSecure.equalsIgnoreCase("dynamic"))) {
            _logger.log(Level.WARNING, "vs.invalidSsoCookieSecure", new Object[]{cookieSecure, this.getID()});
        } else {
            this.ssoCookieSecure = cookieSecure;
        }
    }

    void configureErrorReportValve() {
        Property prop = this.vsBean.getProperty("errorReportValve");
        if (prop != null) {
            this.setErrorReportValveClass(prop.getValue());
        }
    }
}

