/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.osgi.Extender;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ExtenderManager {
    private static final Logger logger = Logger.getLogger(ExtenderManager.class.getPackage().getName());
    private BundleContext context;
    private Events events = (Events)Globals.get(Events.class);
    private EventListener listener;
    private Semaphore serverReady = new Semaphore(0);
    private ServiceTracker extenderTracker;

    public ExtenderManager(BundleContext context) {
        this.context = context;
    }

    public void start() throws Exception {
        this.waitForServerToStart();
    }

    public void stop() throws Exception {
        this.unregisterGlassFishShutdownHook();
        if (this.extenderTracker != null) {
            this.extenderTracker.close();
            this.extenderTracker = null;
        }
        this.stopExtenders();
    }

    public void doActualWork() {
        this.registerGlassFishShutdownHook();
        this.extenderTracker = new ExtenderTracker(this.context);
        this.extenderTracker.open();
    }

    private void waitForServerToStart() {
        EventListener serverStartedListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (EventTypes.SERVER_READY.equals((Object)event.type())) {
                    logger.logp(Level.INFO, "WebExtender", "event", "Received Server Started Event");
                    ExtenderManager.this.serverReady.release();
                    ExtenderManager.this.events.unregister((EventListener)this);
                }
            }
        };
        this.events.register(serverStartedListener);
        new Thread(new Runnable(){

            public void run() {
                if (!ExtenderManager.this.isServerStarted()) {
                    logger.logp(Level.INFO, "WebExtender", "run", "Waiting for Server to start");
                    try {
                        ExtenderManager.this.serverReady.acquire();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                ExtenderManager.this.doActualWork();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopExtenders() {
        try {
            for (ServiceReference ref : this.context.getServiceReferences(Extender.class.getName(), null)) {
                Object var7_7;
                Extender e = (Extender)Extender.class.cast(this.context.getService(ref));
                try {
                    e.stop();
                    var7_7 = null;
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    this.context.ungetService(ref);
                    throw throwable;
                }
                this.context.ungetService(ref);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.logp(Level.WARNING, "ExtenderManager", "stopExtenders", "Not able to stop all extenders", e);
        }
    }

    private boolean isServerStarted() {
        ServerEnvironment serverEnv = (ServerEnvironment)Globals.get(ServerEnvironment.class);
        return serverEnv.getStatus() == ServerEnvironment.Status.started;
    }

    private void registerGlassFishShutdownHook() {
        this.listener = new EventListener(){

            public void event(EventListener.Event event) {
                if (EventTypes.PREPARE_SHUTDOWN.equals((Object)event.type())) {
                    ExtenderManager.this.stopExtenders();
                }
            }
        };
        this.events.register(this.listener);
    }

    private void unregisterGlassFishShutdownHook() {
        if (this.listener != null) {
            this.events.unregister(this.listener);
        }
    }

    private class ExtenderTracker
    extends ServiceTracker {
        ExtenderTracker(BundleContext context) {
            super(context, Extender.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Extender e = (Extender)Extender.class.cast(this.context.getService(reference));
            e.start();
            return e;
        }
    }
}

