/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationContextFacade
implements ServletContext {
    private static HashMap classCache = new HashMap();
    private HashMap objectCache;
    private static Logger sysLog;
    private ApplicationContext context = null;

    public ApplicationContextFacade(ApplicationContext context) {
        this.context = context;
        this.objectCache = new HashMap();
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        ServletContext theContext = null;
        theContext = SecurityUtil.isPackageProtectionEnabled() ? (ServletContext)this.doPrivileged("getContext", new Object[]{uripath}) : this.context.getContext(uripath);
        if (theContext != null && theContext instanceof ApplicationContext) {
            theContext = ((ApplicationContext)theContext).getFacade();
        }
        return theContext;
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getMimeType", new Object[]{file});
        }
        return this.context.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Set)this.doPrivileged("getResourcePaths", new Object[]{path});
        }
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                return (URL)this.invokeMethod(this.context, "getResource", new Object[]{path});
            }
            catch (Throwable t) {
                if (t instanceof MalformedURLException) {
                    throw (MalformedURLException)t;
                }
                return null;
            }
        }
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (InputStream)this.doPrivileged("getResourceAsStream", new Object[]{path});
        }
        return this.context.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (RequestDispatcher)this.doPrivileged("getRequestDispatcher", new Object[]{path});
        }
        return this.context.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (RequestDispatcher)this.doPrivileged("getNamedDispatcher", new Object[]{name});
        }
        return this.context.getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return (Servlet)this.invokeMethod(this.context, "getServlet", new Object[]{name});
            }
            catch (Throwable t) {
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                return null;
            }
        }
        return this.context.getServlet(name);
    }

    public Enumeration<Servlet> getServlets() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)this.doPrivileged("getServlets", null);
        }
        return this.context.getServlets();
    }

    public Enumeration<String> getServletNames() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)this.doPrivileged("getServletNames", null);
        }
        return this.context.getServletNames();
    }

    public void log(String msg) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("log", new Object[]{msg});
        } else {
            this.context.log(msg);
        }
    }

    public void log(Exception exception, String msg) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("log", new Class[]{Exception.class, String.class}, new Object[]{exception, msg});
        } else {
            this.context.log(exception, msg);
        }
    }

    public void log(String message, Throwable throwable) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("log", new Class[]{String.class, Throwable.class}, new Object[]{message, throwable});
        } else {
            this.context.log(message, throwable);
        }
    }

    public String getRealPath(String path) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getRealPath", new Object[]{path});
        }
        return this.context.getRealPath(path);
    }

    public String getServerInfo() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getServerInfo", null);
        }
        return this.context.getServerInfo();
    }

    public String getInitParameter(String name) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getInitParameter", new Object[]{name});
        }
        return this.context.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)this.doPrivileged("getInitParameterNames", null);
        }
        return this.context.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Boolean)this.doPrivileged("setInitParameter", new Object[]{name, value});
        }
        return this.context.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return this.doPrivileged("getAttribute", new Object[]{name});
        }
        return this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)this.doPrivileged("getAttributeNames", null);
        }
        return this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("setAttribute", new Object[]{name, object});
        } else {
            this.context.setAttribute(name, object);
        }
    }

    public void removeAttribute(String name) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            this.doPrivileged("removeAttribute", new Object[]{name});
        } else {
            this.context.removeAttribute(name);
        }
    }

    public String getServletContextName() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)this.doPrivileged("getServletContextName", null);
        }
        return this.context.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addServlet", new Object[]{servletName, className});
        }
        return this.context.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addServlet", new Object[]{servletName, servlet});
        }
        return this.context.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration.Dynamic)this.doPrivileged("addServlet", new Object[]{servletName, servletClass});
        }
        return this.context.addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (T)((Servlet)this.doPrivileged("createServlet", new Object[]{clazz}));
        }
        return this.context.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (ServletRegistration)this.doPrivileged("getServletRegistration", new Object[]{servletName});
        }
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Map)this.doPrivileged("getServletRegistrations", null);
        }
        return this.context.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration.Dynamic)this.doPrivileged("addFilter", new Object[]{filterName, className});
        }
        return this.context.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration.Dynamic)this.doPrivileged("addFilter", new Object[]{filterName, filter});
        }
        return this.context.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration.Dynamic)this.doPrivileged("addFilter", new Object[]{filterName, filterClass});
        }
        return this.context.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (T)((Filter)this.doPrivileged("createFilter", new Object[]{clazz}));
        }
        return this.context.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (FilterRegistration)this.doPrivileged("getFilterRegistration", new Object[]{filterName});
        }
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Map)this.doPrivileged("getFilterRegistrations", null);
        }
        return this.context.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (SessionCookieConfig)this.doPrivileged("getSessionCookieConfig", null);
        }
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.context.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.context.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.context.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (T)((EventListener)this.doPrivileged("createListener", new Object[]{clazz}));
        }
        return this.context.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public StandardContext getUnwrappedContext() {
        return this.context.getUnwrappedContext();
    }

    private Object doPrivileged(ApplicationContext appContext, String methodName, Object[] params) {
        try {
            Object object = this.invokeMethod(appContext, methodName, params);
            Object var6_6 = null;
            params = null;
            return object;
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException(t.getMessage());
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                params = null;
                throw throwable;
            }
        }
    }

    private Object doPrivileged(String methodName, Object[] params) {
        try {
            Object object = this.invokeMethod(this.context, methodName, params);
            Object var5_5 = null;
            params = null;
            return object;
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException(t.getMessage());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                params = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(ApplicationContext appContext, String methodName, Object[] params) throws Throwable {
        try {
            Method method = (Method)this.objectCache.get(methodName);
            if (method == null) {
                method = appContext.getClass().getMethod(methodName, (Class[])classCache.get(methodName));
                this.objectCache.put(methodName, method);
            }
            Object object = this.executeMethod(method, appContext, params);
            Object var7_8 = null;
            params = null;
            return object;
        }
        catch (Exception ex) {
            try {
                this.handleException(ex, methodName);
                Object var5_7 = null;
                Object var7_9 = null;
                params = null;
                return var5_7;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                params = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doPrivileged(String methodName, Class[] clazz, Object[] params) {
        try {
            Method method = this.context.getClass().getMethod(methodName, clazz);
            Object object = this.executeMethod(method, this.context, params);
            Object var7_9 = null;
            params = null;
            return object;
        }
        catch (Exception ex) {
            try {
                try {
                    this.handleException(ex, methodName);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage());
                }
                Object var5_8 = null;
                Object var7_10 = null;
                params = null;
                return var5_8;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                params = null;
                throw throwable;
            }
        }
    }

    private Object executeMethod(final Method method, final ApplicationContext context, final Object[] params) throws PrivilegedActionException, IllegalAccessException, InvocationTargetException {
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    return method.invoke((Object)context, params);
                }
            });
        }
        return method.invoke((Object)context, params);
    }

    private void handleException(Exception ex, String methodName) throws Throwable {
        if (sysLog.isLoggable(Level.FINE)) {
            sysLog.log(Level.FINE, "ApplicationContextFacade." + methodName, ex);
        }
        if (ex instanceof PrivilegedActionException) {
            ex = ((PrivilegedActionException)ex).getException();
        }
        Throwable realException = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex;
        throw realException;
    }

    static {
        Class[] clazz = new Class[]{String.class};
        classCache.put("getContext", clazz);
        classCache.put("getMimeType", clazz);
        classCache.put("getResourcePaths", clazz);
        classCache.put("getResource", clazz);
        classCache.put("getResourceAsStream", clazz);
        classCache.put("getRequestDispatcher", clazz);
        classCache.put("getNamedDispatcher", clazz);
        classCache.put("getServlet", clazz);
        classCache.put("getInitParameter", clazz);
        classCache.put("setAttribute", new Class[]{String.class, Object.class});
        classCache.put("removeAttribute", clazz);
        classCache.put("getRealPath", clazz);
        classCache.put("getAttribute", clazz);
        classCache.put("log", clazz);
        sysLog = Logger.getLogger(ApplicationContextFacade.class.getName());
    }
}

