/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.osgi.BundleClassLoader;
import org.glassfish.web.osgi.OSGiWarHandler;
import org.osgi.framework.Bundle;

public class OSGiDeploymentContextImpl
extends DeploymentContextImpl {
    private static final Logger logger = Logger.getLogger(OSGiDeploymentContextImpl.class.getPackage().getName());
    private WebappClassLoader shareableTempClassLoader;
    private WebappClassLoader finalClassLoader;
    private Bundle bundle;

    public OSGiDeploymentContextImpl(ActionReport actionReport, Logger logger, ReadableArchive source, OpsParams params, ServerEnvironment env, Bundle bundle) throws Exception {
        super(actionReport, logger, source, params, env);
        this.bundle = bundle;
        this.setupClassLoader();
        this.setArchiveHandler((ArchiveHandler)new OSGiWarHandler());
    }

    private void setupClassLoader() throws Exception {
        final BundleClassLoader delegate1 = new BundleClassLoader(this.bundle);
        final ClassLoader delegate2 = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getAPIClassLoader();
        ClassLoader parent = new ClassLoader(){

            @Override
            protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                try {
                    return delegate1.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe) {
                    return delegate2.loadClass(name);
                }
            }

            @Override
            public URL getResource(String name) {
                URL url = delegate1.getResource(name);
                if (url == null) {
                    url = delegate2.getResource(name);
                }
                return url;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                enumerators.add(delegate1.getResources(name));
                enumerators.add(delegate2.getResources(name));
                return new CompositeEnumeration(enumerators);
            }
        };
        this.shareableTempClassLoader = this.finalClassLoader = new WebappClassLoader(parent){

            public URL[] getURLs() {
                return this.convert((String)OSGiDeploymentContextImpl.this.bundle.getHeaders().get("Bundle-ClassPath"));
            }

            private URL[] convert(String bcp) {
                ArrayList<URL> urls = new ArrayList<URL>();
                StringTokenizer entries = new StringTokenizer(bcp, ",;");
                while (entries.hasMoreTokens()) {
                    String entry = entries.nextToken().trim();
                    if (entry.startsWith("/")) {
                        entry = entry.substring(1);
                    }
                    try {
                        URL url = new File(OSGiDeploymentContextImpl.this.getSourceDir(), entry).toURI().toURL();
                        urls.add(url);
                    }
                    catch (MalformedURLException e) {
                        logger.logp(Level.WARNING, "OSGiDeploymentContextImpl", "convert", "Failed to add {0} as classpath because of", new Object[]{entry, e.getMessage()});
                    }
                }
                return urls.toArray(new URL[0]);
            }
        };
        this.finalClassLoader.start();
    }

    public void createDeploymentClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
    }

    public void createApplicationClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
    }

    public ClassLoader getClassLoader() {
        if (this.getPhase() != ExtendedDeploymentContext.Phase.PREPARE) {
            return this.finalClassLoader;
        }
        return this.shareableTempClassLoader;
    }

    public ClassLoader getFinalClassLoader() {
        return this.finalClassLoader;
    }

    public synchronized ClassLoader getClassLoader(boolean sharable) {
        throw new RuntimeException("Assertion Failure: This method should not be called");
    }
}

