/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.osgi;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import java.net.URI;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.web.osgi.JavaEEDeploymentRequest;
import org.glassfish.web.osgi.JavaEEUndeploymentRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiWebContainer {
    private Map<Bundle, OSGiApplicationInfo> applications = new HashMap<Bundle, OSGiApplicationInfo>();
    private static final Logger logger = Logger.getLogger(OSGiWebContainer.class.getPackage().getName());
    private Deployment deployer = (Deployment)Globals.get(Deployment.class);
    private ArchiveFactory archiveFactory = (ArchiveFactory)Globals.get(ArchiveFactory.class);
    private ServerEnvironmentImpl env = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);

    public synchronized void deploy(Bundle b) throws Exception {
        OSGiApplicationInfo osgiAppInfo = this.applications.get(b);
        if (osgiAppInfo != null) {
            logger.logp(Level.WARNING, "OSGiWebContainer", "deploy", "Bundle {0} is already deployed at {1} ", new Object[]{b, osgiAppInfo.appInfo.getSource()});
            return;
        }
        ActionReport report = this.getReport();
        osgiAppInfo = this.deployJavaEEArtifacts(b, report);
        if (osgiAppInfo != null) {
            try {
                ServletContext sc = this.setServletContextAttr(osgiAppInfo);
                this.registerService(b, sc);
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "OSGiWebContainer", "deploy", "Rolling back deployment as exception occured", e);
                this.undeployJavaEEArtifacts(osgiAppInfo, report);
            }
            this.applications.put(b, osgiAppInfo);
            logger.logp(Level.INFO, "OSGiWebContainer", "deploy", "deployed bundle {0} at {1}", new Object[]{b, osgiAppInfo.appInfo.getSource().getURI()});
        } else {
            logger.logp(Level.WARNING, "OSGiWebContainer", "deploy", "could not deploy bundle {0}. See previous messages for further information", new Object[]{b});
        }
    }

    private OSGiApplicationInfo deployJavaEEArtifacts(Bundle b, ActionReport report) {
        JavaEEDeploymentRequest request = new JavaEEDeploymentRequest(this.deployer, this.archiveFactory, this.env, report, b);
        return request.execute();
    }

    public synchronized void undeploy(Bundle b) throws Exception {
        OSGiApplicationInfo osgiAppInfo = this.applications.get(b);
        if (osgiAppInfo == null) {
            throw new RuntimeException("No applications for bundle " + b);
        }
        ActionReport report = this.getReport();
        this.undeployJavaEEArtifacts(osgiAppInfo, report);
        URI location = osgiAppInfo.appInfo.getSource().getURI();
        switch (report.getActionExitCode()) {
            case FAILURE: {
                logger.logp(Level.WARNING, "OSGiWebContainer", "undeploy", "Failed to undeploy {0} from {1}. See previous messages for further information.", new Object[]{b, location});
                break;
            }
            default: {
                logger.logp(Level.INFO, "OSGiWebContainer", "undeploy", "Undeployed bundle {0} from {1}", new Object[]{b, location});
            }
        }
        this.applications.remove(b);
    }

    private ActionReport undeployJavaEEArtifacts(OSGiApplicationInfo osgiAppInfo, ActionReport report) {
        JavaEEUndeploymentRequest request = new JavaEEUndeploymentRequest(this.deployer, this.env, report, osgiAppInfo);
        request.execute();
        return report;
    }

    public void undeployAll() {
        for (Bundle b : new HashSet<Bundle>(this.applications.keySet())) {
            try {
                this.undeploy(b);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, "OSGiWebContainer", "undeployAll", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
                logger.logp(Level.SEVERE, "OSGiWebContainer", "undeployAll", "Exception Stack Trace", e);
            }
        }
    }

    private ActionReport getReport() {
        return (ActionReport)Globals.getDefaultHabitat().getComponent(ActionReport.class, "plain");
    }

    private ServletContext setServletContextAttr(OSGiApplicationInfo osgiAppInfo) {
        ServletContext sc = this.getServletContext(osgiAppInfo.appInfo);
        assert (sc != null);
        sc.setAttribute("osgi-bundlecontext", (Object)osgiAppInfo.bundle.getBundleContext());
        return sc;
    }

    private ServletContext getServletContext(ApplicationInfo appInfo) {
        if (appInfo.getModuleInfos().size() == 1) {
            ModuleInfo m = (ModuleInfo)appInfo.getModuleInfos().iterator().next();
            EngineRef e = m.getEngineRefForContainer(WebContainer.class);
            assert (e != null);
            WebApplication a = (WebApplication)e.getApplicationContainer();
            Set wms = a.getWebModules();
            assert (wms.size() == 1);
            if (wms.size() == 1) {
                return ((WebModule)wms.iterator().next()).getServletContext();
            }
        }
        return null;
    }

    private void registerService(Bundle b, ServletContext sc) {
        BundleContext bctx;
        Properties props = new Properties();
        props.setProperty("osgi.web.symbolicname", b.getSymbolicName());
        String cpath = (String)b.getHeaders().get("Web-ContextPath");
        props.setProperty("osgi.web.contextpath", cpath);
        String version = (String)b.getHeaders().get("Bundle-Version");
        if (version != null) {
            props.setProperty("osgi.web.version", version);
        }
        if ((bctx = b.getBundleContext()) != null) {
            bctx.registerService(ServletContext.class.getName(), (Object)sc, (Dictionary)props);
            logger.logp(Level.INFO, "OSGiWebContainer", "registerService", "Registered ServletContext as a service with properties: {0} ", new Object[]{props});
        } else {
            logger.logp(Level.WARNING, "OSGiWebContainer", "registerService", "Not able to register ServletContext as a service as bctx is null");
        }
    }

    static class OSGiApplicationInfo {
        ApplicationInfo appInfo;
        boolean isDirectoryDeployment;
        Bundle bundle;

        OSGiApplicationInfo() {
        }
    }
}

