/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationDispatcher;

public class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getName());
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private String zeroArgDispatchTarget = null;

    public AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) {
        this.origRequest = origRequest;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = isOriginalRequestAndResponse;
        this.zeroArgDispatchTarget = !isOriginalRequestAndResponse && servletRequest instanceof HttpServletRequest ? this.getZeroArgDispatchTarget((HttpServletRequest)servletRequest) : this.getZeroArgDispatchTarget(origRequest);
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    Request getOriginalRequest() {
        return this.origRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    public void dispatch() {
        if (this.zeroArgDispatchTarget == null) {
            log.severe("Unable to determine target of zero-arg dispatch");
        } else {
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(this.zeroArgDispatchTarget);
            if (dispatcher != null) {
                this.origRequest.setOkToReinitializeAsync(true);
                this.origRequest.setAsyncStarted(false);
                pool.execute(new Handler(this, dispatcher));
            } else {
                log.warning("Unable to acquire RequestDispatcher for " + this.zeroArgDispatchTarget);
            }
        }
    }

    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        if (dispatcher != null) {
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(this, dispatcher));
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path);
        }
    }

    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        if (dispatcher != null) {
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(this, dispatcher));
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path + "in servlet context " + context.getContextPath());
        }
    }

    public void complete() {
        this.origRequest.asyncComplete();
    }

    public void start(Runnable run) {
        pool.execute(run);
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = isOriginalRequestAndResponse;
        if (isOriginalRequestAndResponse) {
            this.zeroArgDispatchTarget = this.getZeroArgDispatchTarget(this.origRequest);
        } else if (servletRequest instanceof HttpServletRequest) {
            this.zeroArgDispatchTarget = this.getZeroArgDispatchTarget((HttpServletRequest)servletRequest);
        } else {
            log.warning("Unable to determine target of zero-argument dispatch");
        }
    }

    private String getZeroArgDispatchTarget(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        if (req.getServletPath() != null) {
            sb.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            sb.append(req.getPathInfo());
        }
        return sb.toString();
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
        }

        public void run() {
            try {
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                if (!this.asyncContext.getRequest().isAsyncStarted()) {
                    this.asyncContext.complete();
                }
            }
            catch (Throwable t) {
                this.asyncContext.getOriginalRequest().asyncError(t);
            }
        }
    }
}

