/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.listener")
public class CreateHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttpListener.class);
    @Param(name="listeneraddress")
    String listenerAddress;
    @Param(name="listenerport")
    String listenerPort;
    @Param(name="defaultvs", optional=true)
    String defaultVS;
    @Param(name="default-virtual-server", optional=true)
    String defaultVirtualServer;
    @Param(name="servername", optional=true)
    String serverName;
    @Param(name="acceptorthreads", optional=true)
    String acceptorThreads;
    @Param(name="xpowered", optional=true, defaultValue="true")
    Boolean xPoweredBy;
    @Param(name="redirectport", optional=true)
    String redirectPort;
    @Param(name="securityenabled", optional=true, defaultValue="false")
    Boolean securityEnabled;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean secure;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Inject
    Configs configs;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        HttpService httpService = config.getHttpService();
        if (!(this.verifyUniqueName(report, networkConfig) && this.verifyUniquePort(report, networkConfig) && this.verifyDefaultVirtualServer(report, httpService))) {
            return;
        }
        VirtualServer vs = httpService.getVirtualServerByName(this.defaultVirtualServer);
        try {
            Transport transport = this.createOrGetTransport(networkConfig);
            Protocol protocol = this.createProtocol(networkConfig);
            ThreadPool threadPool = this.getThreadPool(networkConfig);
            this.createNetworkListener(networkConfig, transport, protocol, threadPool);
            this.updateVirtualServer(vs);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.http.listener.fail", "Creation of: " + this.listenerId + "failed because of: " + e.getMessage(), new Object[]{this.listenerId, e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void updateVirtualServer(VirtualServer vs) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

            public Object run(VirtualServer avs) throws PropertyVetoException {
                String DELIM = ",";
                String lss = avs.getNetworkListeners();
                boolean listenerShouldBeAdded = true;
                if (lss == null || lss.length() == 0) {
                    lss = CreateHttpListener.this.listenerId;
                } else if (!lss.contains(CreateHttpListener.this.listenerId)) {
                    if (!lss.endsWith(DELIM)) {
                        lss = lss + DELIM;
                    }
                    lss = lss + CreateHttpListener.this.listenerId;
                } else {
                    listenerShouldBeAdded = false;
                }
                if (listenerShouldBeAdded) {
                    avs.setNetworkListeners(lss);
                }
                return avs;
            }
        }, (ConfigBeanProxy)vs);
    }

    private void createNetworkListener(NetworkConfig networkConfig, final Transport transport, final Protocol protocol, final ThreadPool threadPool) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners listenersParam) throws TransactionFailure {
                NetworkListener newListener = (NetworkListener)listenersParam.createChild(NetworkListener.class);
                newListener.setName(CreateHttpListener.this.listenerId);
                newListener.setAddress(CreateHttpListener.this.listenerAddress);
                newListener.setPort(CreateHttpListener.this.listenerPort);
                newListener.setTransport(transport.getName());
                newListener.setProtocol(protocol.getName());
                newListener.setThreadPool(threadPool.getName());
                newListener.setEnabled(CreateHttpListener.this.enabled.toString());
                listenersParam.getNetworkListener().add(newListener);
                return newListener;
            }
        }, (ConfigBeanProxy)networkConfig.getNetworkListeners());
        ((Transactions)this.habitat.getComponent(Transactions.class)).waitForDrain();
    }

    private boolean verifyDefaultVirtualServer(ActionReport report, HttpService httpService) {
        if (this.defaultVS != null && this.defaultVirtualServer != null && !this.defaultVS.equals(this.defaultVirtualServer)) {
            report.setMessage(localStrings.getLocalString("create.http.listener.vs.bothparams", "--defaultVS and --default-virtual-server conflict.  Please use only --default-virtu     al-server to specify this value."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.defaultVirtualServer == null && this.defaultVS != null) {
            this.defaultVirtualServer = this.defaultVS;
        }
        if (!this.defaultVirtualServerExists(httpService)) {
            report.setMessage(localStrings.getLocalString("create.http.listener.vs.notexists", "Virtual Server, {0} doesn't exist", new Object[]{this.defaultVirtualServer}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean verifyUniquePort(ActionReport report, NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.listenerPort) || !listener.getAddress().trim().equals(this.listenerAddress)) continue;
            String def = "Port is already taken by another listener, choose another port.";
            String msg = localStrings.getLocalString("port.occupied", def, new Object[]{this.listenerPort, listener.getName(), this.listenerAddress});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean verifyUniqueName(ActionReport report, NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getName().equals(this.listenerId)) continue;
            report.setMessage(localStrings.getLocalString("create.http.listener.duplicate", "Http Listener named {0} already exists.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private void registerWithHabitat(NetworkListener newListener) {
        Dom dom = Dom.unwrap((ConfigBeanProxy)newListener);
        this.habitat.add((Inhabitant)dom);
        String key = dom.getKey();
        for (String contract : this.getContracts(dom.model)) {
            this.habitat.addIndex((Inhabitant)dom, contract, key);
        }
        if (key != null) {
            this.habitat.addIndex((Inhabitant)dom, dom.model.targetTypeName, key);
        }
        dom.initializationCompleted();
    }

    private Collection<String> getContracts(ConfigModel model) {
        try {
            Field field = model.getClass().getDeclaredField("contracts");
            field.setAccessible(true);
            Object value = field.get(model);
            return (Collection)value;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private ThreadPool getThreadPool(NetworkConfig config) {
        List pools = ((Config)config.getParent(Config.class)).getThreadPools().getThreadPool();
        ThreadPool target = null;
        for (ThreadPool pool : pools) {
            if (!"http-thread-pool".equals(pool.getName())) continue;
            target = pool;
        }
        if (target == null && !pools.isEmpty()) {
            target = (ThreadPool)pools.get(0);
        }
        return target;
    }

    private Transport createOrGetTransport(NetworkConfig config) throws TransactionFailure {
        Transports transports = config.getTransports();
        Transport transport = null;
        for (Transport item : transports.getTransport()) {
            if (!"tcp".equals(item.getName())) continue;
            transport = item;
        }
        if (transport == null) {
            transport = (Transport)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

                public Object run(Transports param) throws TransactionFailure {
                    Transport newTransport = (Transport)param.createChild(Transport.class);
                    newTransport.setName(CreateHttpListener.this.listenerId);
                    newTransport.setAcceptorThreads(CreateHttpListener.this.acceptorThreads);
                    param.getTransport().add(newTransport);
                    return newTransport;
                }
            }, (ConfigBeanProxy)config.getTransports());
        }
        return transport;
    }

    private Protocol createProtocol(NetworkConfig config) throws TransactionFailure {
        return (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol protocol = (Protocol)param.createChild(Protocol.class);
                protocol.setSecurityEnabled(CreateHttpListener.this.securityEnabled.toString());
                protocol.setName(CreateHttpListener.this.listenerId);
                param.getProtocol().add(protocol);
                Http http = (Http)protocol.createChild(Http.class);
                http.setDefaultVirtualServer(CreateHttpListener.this.defaultVirtualServer);
                http.setXpoweredBy(CreateHttpListener.this.xPoweredBy.toString());
                http.setServerName(CreateHttpListener.this.serverName);
                protocol.setHttp(http);
                return protocol;
            }
        }, (ConfigBeanProxy)config.getProtocols());
    }

    private boolean defaultVirtualServerExists(HttpService httpService) {
        if (this.defaultVirtualServer == null) {
            return false;
        }
        List list = httpService.getVirtualServer();
        for (VirtualServer vs : list) {
            String currId = vs.getId();
            if (currId == null || !currId.equals(this.defaultVirtualServer)) continue;
            return true;
        }
        return false;
    }
}

