/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="web-request-mon", group="monitoring")
@ManagedObject
@Description(value="Web Request Statistics")
public class RequestStatsProvider {
    private static final String PROCESSING_TIME_DESCRIPTION = "The request processing time (average, maximum, minimum, and total)";
    private CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Cumulative number of requests processed so far");
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400");
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Logger logger;
    private String virtualServerName = null;
    private String moduleName = null;

    public RequestStatsProvider(String appName, String vsName, Logger logger) {
        this.logger = logger;
        this.virtualServerName = vsName;
        this.moduleName = appName;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Cumulative number of requests processed so far")
    public CountStatistic getRequestCount() {
        return this.requestCount;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="Number of responses with a status code that is greater than or equal to 400")
    public CountStatistic getErrorCount() {
        return this.errorCount;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="The request processing time (average, maximum, minimum, and total)")
    public TimeStatistic getProcessingTime() {
        return new TimeStatisticImpl((long)this.requestProcessTime.getTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "ProcessingTime", "millisecond", PROCESSING_TIME_DESCRIPTION, this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
    }

    @ProbeListener(value="glassfish:web:http-service:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("[TM]requestStartEvent Unprocessed received - virtual-server = " + serverName + ":" + serverPort + ": application = " + contextPath + " : servlet = " + servletPath + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        }
        if (this.virtualServerName != null && this.moduleName != null) {
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.requestProcessTime.entry();
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("[TM]requestStartEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + servletPath + " : port = " + serverPort);
                }
            }
        } else {
            this.requestProcessTime.entry();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("[TM]requestStartEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath);
            }
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath, @ProbeParam(value="statusCode") int statusCode) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("[TM]requestEndEvent Unprocessed received - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath + " :Response code = " + statusCode + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        }
        if (this.virtualServerName != null && this.moduleName != null) {
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.requestCount.increment();
                this.requestProcessTime.exit();
                if (statusCode >= 400) {
                    this.errorCount.increment();
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("[TM]requestEndEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + servletPath + " : port = " + serverPort + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
                }
            }
        } else {
            this.requestCount.increment();
            this.requestProcessTime.exit();
            if (statusCode >= 400) {
                this.errorCount.increment();
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("[TM]requestEndEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath + " : port = " + serverPort + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
            }
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.virtualServerName;
    }
}

