/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import com.sun.enterprise.config.serverbeans.Engine;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.web.plugin.common.ContextParam;
import org.glassfish.web.plugin.common.WebModuleConfig;
import org.glassfish.web.plugin.common.WebModuleConfigCommand;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-web-context-param")
@I18n(value="setWebContextParam.command")
@Scoped(value=PerLookup.class)
public class SetWebContextParamCommand
extends WebModuleConfigCommand {
    @Param(name="name")
    private String name;
    @Param(name="value", optional=true)
    private String value;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="ignoreDescriptorItem", optional=true)
    private Boolean ignoreDescriptorItem;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.setContextParam(this.engine(report), this.name, this.value, this.description, this.ignoreDescriptorItem);
        }
        catch (Exception e) {
            this.fail(report, e, "errSetContextParam", "Error setting context param", new Object[0]);
        }
    }

    private void setContextParam(Engine owningEngine, String paramName, String paramValue, String description, Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        WebModuleConfig config = WebModuleConfig.Duck.webModuleConfig(owningEngine);
        if (config == null) {
            this.createContextParamOnNewWMC(owningEngine, paramName, paramValue, description, ignoreDescriptorItem);
        } else {
            ContextParam cp = config.getContextParam(paramName);
            if (cp == null) {
                this.createContextParamOnExistingWMC(config, paramName, paramValue, description, ignoreDescriptorItem);
            } else {
                this.modifyContextParam(cp, paramValue, description, ignoreDescriptorItem);
            }
        }
    }

    private void createContextParamOnNewWMC(Engine owningEngine, final String paramName, final String paramValue, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Engine>(){

            public Object run(Engine e) throws PropertyVetoException, TransactionFailure {
                WebModuleConfig config = (WebModuleConfig)e.createChild(WebModuleConfig.class);
                e.getApplicationConfigs().add(config);
                ContextParam newParam = (ContextParam)config.createChild(ContextParam.class);
                config.getContextParam().add(newParam);
                SetWebContextParamCommand.this.set(newParam, paramName, paramValue, description, ignoreDescriptorItem);
                return config;
            }
        }, (ConfigBeanProxy)owningEngine);
    }

    private void createContextParamOnExistingWMC(WebModuleConfig config, final String paramName, final String paramValue, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<WebModuleConfig>(){

            public Object run(WebModuleConfig cf) throws PropertyVetoException, TransactionFailure {
                ContextParam param = (ContextParam)cf.createChild(ContextParam.class);
                cf.getContextParam().add(param);
                SetWebContextParamCommand.this.set(param, paramName, paramValue, description, ignoreDescriptorItem);
                return param;
            }
        }, (ConfigBeanProxy)config);
    }

    private void modifyContextParam(ContextParam param, final String paramValue, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ContextParam>(){

            public Object run(ContextParam cp) throws PropertyVetoException, TransactionFailure {
                SetWebContextParamCommand.this.set(cp, cp.getParamName(), paramValue, description, ignoreDescriptorItem);
                return cp;
            }
        }, (ConfigBeanProxy)param);
    }

    private void set(ContextParam param, String paramName, String paramValue, String description, Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        if (ignoreDescriptorItem != null) {
            param.setIgnoreDescriptorItem(ignoreDescriptorItem.toString());
        }
        if (description != null) {
            param.setDescription(description);
        }
        if (paramValue != null) {
            param.setParamValue(paramValue);
        }
        if (paramName != null) {
            param.setParamName(paramName);
        }
    }
}

