/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.web.admin.monitor.TimeStatData;

@AMXMetadata(type="servlet-instance-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container Servlet Instance Statistics")
public class ServletInstanceStatsProvider {
    private static final String ERROR_COUNT_DESCRIPTION = "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400";
    private static final String MAX_TIME_DESCRIPTION = "The longest response time of the Servlet";
    private static final String PROCESSING_TIME_DESCRIPTION = "Average request processing time";
    private static final String REQUEST_COUNT_DESCRIPTION = "Number of requests processed by the Servlet";
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400");
    private CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Number of requests processed by the Servlet");
    private CountStatisticImpl maxTime = new CountStatisticImpl("MaxTime", "millisecond", "The longest response time of the Servlet");
    private CountStatisticImpl processingTime = new CountStatisticImpl("ProcessingTime", "millisecond", "Average request processing time");
    private TimeStatisticImpl requestProcessTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "", "", "", System.currentTimeMillis(), -1L);
    private String servletName;
    private String moduleName;
    private String vsName;
    private Logger logger;
    private ThreadLocal<TimeStatData> timeStatDataLocal = new ThreadLocal<TimeStatData>(){
        TimeStatData tsd;

        @Override
        protected TimeStatData initialValue() {
            this.tsd = new TimeStatData();
            return this.tsd;
        }

        @Override
        public TimeStatData get() {
            if (this.tsd == null) {
                this.tsd = new TimeStatData();
            }
            return this.tsd;
        }
    };

    public ServletInstanceStatsProvider(String servletName, String moduleName, String vsName, Logger logger) {
        this.logger = logger;
        this.servletName = servletName;
        this.moduleName = moduleName;
        this.vsName = vsName;
        long curTime = System.currentTimeMillis();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400")
    public CountStatistic getErrorCount() {
        return this.errorCount.getStatistic();
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="The longest response time of the Servlet")
    public CountStatistic getMaximumTime() {
        this.maxTime.setCount(this.requestProcessTime.getMaxTime());
        return this.maxTime;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Average request processing time")
    public CountStatistic getProcessingTime() {
        long count = this.requestProcessTime.getCount();
        long processTime = 0L;
        if (count != 0L) {
            processTime = this.requestProcessTime.getTotalTime() / count;
        }
        this.processingTime.setCount(processTime);
        return this.processingTime;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Number of requests processed by the Servlet")
    public CountStatistic getCount() {
        this.requestCount.setCount(this.requestProcessTime.getCount());
        return this.requestCount;
    }

    @ProbeListener(value="glassfish:web:servlet:beforeServiceEvent")
    public void beforeServiceEvent(@ProbeParam(value="servletName") String servletName, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(servletName, appName, hostName)) {
            this.timeStatDataLocal.get().setEntryTime(System.currentTimeMillis());
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Servlet before service event received - servletName = " + servletName + ": appName = " + appName + ": hostName = " + hostName);
            }
        }
    }

    @ProbeListener(value="glassfish:web:servlet:afterServiceEvent")
    public void afterServiceEvent(@ProbeParam(value="servletName") String servletName, @ProbeParam(value="responseStatus") int responseStatus, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(servletName, appName, hostName)) {
            TimeStatData tsd = this.timeStatDataLocal.get();
            tsd.setExitTime(System.currentTimeMillis());
            this.requestProcessTime.incrementCount(tsd.getTotalTime());
            if (responseStatus >= 400) {
                this.errorCount.increment();
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Servlet after service event received - servletName = " + servletName + ": appName = " + appName + ": hostName = " + hostName);
            }
        }
    }

    @Reset
    public void reset() {
        this.requestProcessTime.reset();
        this.errorCount.reset();
        this.requestCount.reset();
        this.maxTime.reset();
        this.processingTime.reset();
    }

    private boolean isValidEvent(String sName, String mName, String hostName) {
        return this.moduleName.equals(mName) && this.vsName.equals(hostName) && this.servletName.equals(sName);
    }
}

