/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.web.WebModule;
import java.util.Set;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.Servlet;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.core.DynamicServletRegistrationImpl;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicWebServletRegistrationImpl
extends DynamicServletRegistrationImpl {
    private WebBundleDescriptor wbd;
    private WebComponentDescriptor wcd;
    private WebModule webModule;

    public DynamicWebServletRegistrationImpl(StandardWrapper wrapper, WebModule webModule) {
        super(wrapper, (StandardContext)webModule);
        this.webModule = webModule;
        this.wbd = webModule.getWebBundleDescriptor();
        if (this.wbd == null) {
            throw new IllegalStateException("Missing WebBundleDescriptor for " + this.getContext().getName());
        }
        this.wcd = this.wbd.getWebComponentByCanonicalName(wrapper.getName());
        if (this.wcd == null) {
            this.wcd = new WebComponentDescriptor();
            this.wcd.setName(wrapper.getName());
            this.wcd.setCanonicalName(wrapper.getName());
            this.wbd.addWebComponentDescriptor(this.wcd);
            String servletClassName = wrapper.getServletClassName();
            if (servletClassName != null) {
                Class<?> clazz = wrapper.getServletClass();
                if (clazz == null) {
                    if (wrapper.getServlet() != null) {
                        clazz = wrapper.getServlet().getClass();
                    } else {
                        try {
                            clazz = this.ctx.getLoader().getClassLoader().loadClass(servletClassName);
                            wrapper.setServletClass(clazz);
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }
                }
                this.processServletAnnotations(clazz, this.wbd, this.wcd, wrapper);
            } else {
                throw new RuntimeException("Programmatic servlet registration without any supporting servlet class");
            }
        }
    }

    public Set<String> addMapping(String ... urlPatterns) {
        Set conflicts = super.addMapping(urlPatterns);
        if (conflicts.isEmpty() && urlPatterns != null && urlPatterns.length > 0) {
            for (String urlPattern : urlPatterns) {
                this.wcd.addUrlPattern(urlPattern);
            }
        }
        return conflicts;
    }

    public void setRunAsRole(String roleName) {
        super.setRunAsRole(roleName);
        this.wbd.addRole(new Role(roleName));
        RunAsIdentityDescriptor runAsDesc = new RunAsIdentityDescriptor();
        runAsDesc.setRoleName(roleName);
        this.wcd.setRunAsIdentity(runAsDesc);
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        this.webModule.processServletSecurityElement(constraint, this.wbd, this.wcd);
        return super.setServletSecurity(constraint);
    }

    protected void setServletClassName(String className) {
        super.setServletClassName(className);
        try {
            this.processServletAnnotations(this.ctx.getLoader().getClassLoader().loadClass(className), this.wbd, this.wcd, this.wrapper);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected void setServletClass(Class<? extends Servlet> clazz) {
        super.setServletClass(clazz);
        this.processServletAnnotations(clazz, this.wbd, this.wcd, this.wrapper);
    }

    private void processServletAnnotations(Class<? extends Servlet> clazz, WebBundleDescriptor webBundleDescriptor, WebComponentDescriptor wcd, StandardWrapper wrapper) {
        if (clazz.isAnnotationPresent(RunAs.class)) {
            RunAs runAs = clazz.getAnnotation(RunAs.class);
            String roleName = runAs.value();
            webBundleDescriptor.addRole(new Role(roleName));
            RunAsIdentityDescriptor runAsDesc = new RunAsIdentityDescriptor();
            runAsDesc.setRoleName(roleName);
            wcd.setRunAsIdentity(runAsDesc);
        }
        if (clazz.isAnnotationPresent(DeclareRoles.class)) {
            DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
            for (String roleName : declareRoles.value()) {
                webBundleDescriptor.addRole(new Role(roleName));
            }
        }
        if (clazz.isAnnotationPresent(MultipartConfig.class)) {
            MultipartConfig mpConfig = clazz.getAnnotation(MultipartConfig.class);
            wrapper.setMultipartLocation(mpConfig.location());
            wrapper.setMultipartMaxFileSize(mpConfig.maxFileSize());
            wrapper.setMultipartMaxRequestSize(mpConfig.maxRequestSize());
            wrapper.setMultipartFileSizeThreshold(mpConfig.fileSizeThreshold());
        }
        if (clazz.isAnnotationPresent(ServletSecurity.class)) {
            ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
            this.webModule.processServletSecurityElement(new ServletSecurityElement(servletSecurity), webBundleDescriptor, wcd);
        }
    }
}

