/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ProcessingResult;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.web.WebBuilder;
import org.jvnet.hk2.annotations.Inject;

public class EmbeddedWebArchivist
extends WebArchivist {
    @Inject
    WebBuilder builder;
    private final ModuleScanner scanner = new ModuleScanner(){
        final Set<Class> elements = new HashSet<Class>();

        public void process(ReadableArchive archiveFile, Object bundleDesc, ClassLoader classLoader) throws IOException {
            Enumeration entries = archiveFile.entries();
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (!entry.endsWith(".class")) continue;
                try {
                    this.elements.add(classLoader.loadClass(this.toClassName(entry)));
                }
                catch (ClassNotFoundException e) {
                    this.logger.log(Level.FINER, "Cannot load class " + entry, e);
                }
            }
        }

        private String toClassName(String entryName) {
            String name = entryName.substring("WEB-INF/classes/".length(), entryName.length() - ".class".length());
            return name.replaceAll("/", ".");
        }

        public void process(File archiveFile, Object bundleDesc, ClassLoader classLoader) throws IOException {
        }

        public Set getElements() {
            return this.elements;
        }
    };

    protected URL getDefaultWebXML() throws IOException {
        if (this.builder.getDefaultWebXml() != null) {
            return this.builder.getDefaultWebXml();
        }
        return super.getDefaultWebXML();
    }

    protected ProcessingResult processAnnotations(RootDeploymentDescriptor bundleDesc, ModuleScanner scanner, ReadableArchive archive) throws AnnotationProcessorException, IOException {
        return super.processAnnotations(bundleDesc, this.getScanner(), archive);
    }

    public ModuleScanner getScanner() {
        return this.scanner;
    }
}

