/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;

public final class WebContainerListener
implements ContainerListener {
    static Logger _logger = LogDomains.getLogger(WebContainerListener.class, (String)"javax.enterprise.system.container.web");
    private static HashSet beforeEvents = new HashSet();
    private static HashSet afterEvents = new HashSet();
    private InvocationManager invocationMgr;
    private InjectionManager injectionMgr;

    public WebContainerListener(InvocationManager invocationMgr, InjectionManager injectionMgr) {
        this.invocationMgr = invocationMgr;
        this.injectionMgr = injectionMgr;
    }

    public void containerEvent(ContainerEvent event) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ContainerEvent: " + event.getType() + "," + event.getContainer() + "," + event.getData());
        }
        String type = event.getType();
        try {
            if ("afterListenerInstantiated".equals(type)) {
                this.preInvoke((Context)event.getContainer());
                this.injectInstance(event);
                this.postInvoke((Context)event.getContainer());
            }
            if (beforeEvents.contains(type)) {
                this.preInvoke((Context)event.getContainer());
            } else if (afterEvents.contains(type)) {
                this.postInvoke((Context)event.getContainer());
            } else if ("predestroy".equals(type)) {
                this.preDestroy(event);
            }
        }
        catch (Exception ex) {
            String msg = null;
            ResourceBundle rb = _logger.getResourceBundle();
            if (rb != null) {
                msg = rb.getString("web_server.excep_handle_event");
                msg = MessageFormat.format(msg, type);
            } else {
                msg = "Exception during handling of " + type + " event";
            }
            throw new RuntimeException(msg, ex);
        }
        finally {
            if (type.equals("afterFilterDestroyed") || type.equals("afterContextDestroyed")) {
                this.preDestroy(event);
            }
        }
    }

    private void preInvoke(Context ctx) {
        if (ctx instanceof WebModule) {
            WebModule wm = (WebModule)ctx;
            WebComponentInvocation inv = new WebComponentInvocation(wm);
            this.invocationMgr.preInvoke((ComponentInvocation)inv);
        }
    }

    private void postInvoke(Context ctx) {
        if (ctx instanceof WebModule) {
            WebModule wm = (WebModule)ctx;
            WebComponentInvocation inv = new WebComponentInvocation(wm);
            this.invocationMgr.postInvoke((ComponentInvocation)inv);
        }
    }

    private void injectInstance(ContainerEvent event) throws InjectionException {
        WebModule wm;
        WebBundleDescriptor desc;
        if (event.getContainer() instanceof WebModule && (desc = (wm = (WebModule)event.getContainer()).getWebBundleDescriptor()) != null) {
            this.injectionMgr.injectInstance(event.getData(), (JndiNameEnvironment)desc);
        }
    }

    private void preDestroy(ContainerEvent event) {
        try {
            WebModule wm;
            WebBundleDescriptor desc;
            if (event.getContainer() instanceof WebModule && (desc = (wm = (WebModule)event.getContainer()).getWebBundleDescriptor()) != null) {
                this.injectionMgr.invokeInstancePreDestroy(event.getData(), (JndiNameEnvironment)desc);
            }
        }
        catch (InjectionException ie) {
            _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ie);
        }
    }

    static {
        beforeEvents.add("beforeContextInitialized");
        beforeEvents.add("beforeContextDestroyed");
        beforeEvents.add("beforeContextAttributeAdded");
        beforeEvents.add("beforeContextAttributeRemoved");
        beforeEvents.add("beforeContextAttributeReplaced");
        beforeEvents.add("beforeRequestInitialized");
        beforeEvents.add("beforeRequestDestroyed");
        beforeEvents.add("beforeSessionCreated");
        beforeEvents.add("beforeSessionDestroyed");
        beforeEvents.add("beforeSessionAttributeAdded");
        beforeEvents.add("beforeSessionAttributeRemoved");
        beforeEvents.add("beforeSessionAttributeReplaced");
        beforeEvents.add("beforeSessionValueUnbound");
        beforeEvents.add("beforeFilterInitialized");
        beforeEvents.add("beforeFilterDestroyed");
        afterEvents.add("afterContextInitialized");
        afterEvents.add("afterContextDestroyed");
        afterEvents.add("afterContextAttributeAdded");
        afterEvents.add("afterContextAttributeRemoved");
        afterEvents.add("afterContextAttributeReplaced");
        afterEvents.add("afterRequestInitialized");
        afterEvents.add("afterRequestDestroyed");
        afterEvents.add("afterSessionCreated");
        afterEvents.add("afterSessionDestroyed");
        afterEvents.add("afterSessionAttributeAdded");
        afterEvents.add("afterSessionAttributeRemoved");
        afterEvents.add("afterSessionAttributeReplaced");
        afterEvents.add("afterSessionValueUnbound");
        afterEvents.add("afterFilterInitialized");
        afterEvents.add("afterFilterDestroyed");
    }
}

