/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getName());
    private static final long DEFAULT_ASYNC_TIMEOUT_MILLIS = 30000L;
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private static final StringManager STRING_MANAGER = StringManager.getManager("org.apache.catalina.connector");
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private String zeroArgDispatchTarget = null;
    private AtomicBoolean isDispatchInProgress = new AtomicBoolean();
    private AtomicBoolean isOkToConfigure = new AtomicBoolean(true);
    private long asyncTimeoutMillis = 30000L;
    private LinkedList<AsyncListenerHolder> asyncListenerHolders = new LinkedList();

    public AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) {
        this.origRequest = origRequest;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = isOriginalRequestAndResponse;
        this.zeroArgDispatchTarget = !isOriginalRequestAndResponse && servletRequest instanceof HttpServletRequest ? this.getZeroArgDispatchTarget((HttpServletRequest)servletRequest) : this.getZeroArgDispatchTarget(origRequest);
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    Request getOriginalRequest() {
        return this.origRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch() {
        if (this.zeroArgDispatchTarget == null) {
            log.severe("Unable to determine target of zero-arg dispatch");
            return;
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(this.zeroArgDispatchTarget);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(this, dispatcher));
            return;
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + this.zeroArgDispatchTarget);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(this, dispatcher));
            return;
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        if (dispatcher != null) {
            if (!this.isDispatchInProgress.compareAndSet(false, true)) throw new IllegalStateException(STRING_MANAGER.getString("async.dispatchInProgress"));
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(this, dispatcher));
            return;
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path + "in servlet context " + context.getContextPath());
        }
    }

    public void complete() {
        this.origRequest.asyncComplete();
    }

    public void start(Runnable run) {
        pool.execute(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.addListenerIllegalState"));
        }
        LinkedList<AsyncListenerHolder> linkedList = this.asyncListenerHolders;
        synchronized (linkedList) {
            this.asyncListenerHolders.add(new AsyncListenerHolder(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (listener == null || servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null listener, request, or response");
        }
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.addListenerIllegalState"));
        }
        LinkedList<AsyncListenerHolder> linkedList = this.asyncListenerHolders;
        synchronized (linkedList) {
            this.asyncListenerHolders.add(new AsyncListenerHolder(listener, servletRequest, servletResponse));
        }
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        AsyncListener listener = null;
        try {
            listener = (AsyncListener)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        StandardContext ctx = (StandardContext)this.origRequest.getContext();
        if (ctx != null) {
            ctx.fireContainerEvent("afterListenerInstantiated", listener);
        }
        return (T)listener;
    }

    public void setTimeout(long timeout) {
        if (!this.isOkToConfigure.get()) {
            throw new IllegalStateException(STRING_MANAGER.getString("async.setTimeoutIllegalState"));
        }
        this.asyncTimeoutMillis = timeout;
        this.origRequest.setAsyncTimeout(timeout);
    }

    public long getTimeout() {
        return this.asyncTimeoutMillis;
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = isOriginalRequestAndResponse;
        this.isDispatchInProgress.set(false);
        this.setOkToConfigure(true);
        this.notifyAsyncListeners(AsyncEventType.START_ASYNC, null);
        if (isOriginalRequestAndResponse) {
            this.zeroArgDispatchTarget = this.getZeroArgDispatchTarget(this.origRequest);
        } else if (servletRequest instanceof HttpServletRequest) {
            this.zeroArgDispatchTarget = this.getZeroArgDispatchTarget((HttpServletRequest)servletRequest);
        } else {
            log.warning("Unable to determine target of zero-argument dispatch");
        }
    }

    void setOkToConfigure(boolean value) {
        this.isOkToConfigure.set(value);
    }

    private String getZeroArgDispatchTarget(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        if (req.getServletPath() != null) {
            sb.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            sb.append(req.getPathInfo());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsyncListeners(AsyncEventType asyncEventType, Throwable t) {
        LinkedList<AsyncListenerHolder> linkedList = this.asyncListenerHolders;
        synchronized (linkedList) {
            if (this.asyncListenerHolders.isEmpty()) {
                return;
            }
            LinkedList clone = (LinkedList)this.asyncListenerHolders.clone();
            if (asyncEventType.equals((Object)AsyncEventType.START_ASYNC)) {
                this.asyncListenerHolders.clear();
            }
            for (AsyncListenerHolder asyncListenerHolder : clone) {
                AsyncListener asyncListener = asyncListenerHolder.getAsyncListener();
                AsyncEvent asyncEvent = new AsyncEvent((AsyncContext)this, asyncListenerHolder.getRequest(), asyncListenerHolder.getResponse(), t);
                try {
                    switch (asyncEventType) {
                        case COMPLETE: {
                            asyncListener.onComplete(asyncEvent);
                            break;
                        }
                        case TIMEOUT: {
                            asyncListener.onTimeout(asyncEvent);
                            break;
                        }
                        case ERROR: {
                            asyncListener.onError(asyncEvent);
                            break;
                        }
                        case START_ASYNC: {
                            asyncListener.onStartAsync(asyncEvent);
                        }
                    }
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "Error invoking AsyncListener", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<AsyncListenerHolder> linkedList = this.asyncListenerHolders;
        synchronized (linkedList) {
            this.asyncListenerHolders.clear();
        }
    }

    private static class AsyncListenerHolder {
        private AsyncListener listener;
        private ServletRequest request;
        private ServletResponse response;

        public AsyncListenerHolder(AsyncListener listener) {
            this(listener, null, null);
        }

        public AsyncListenerHolder(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this.listener = listener;
            this.request = request;
            this.response = response;
        }

        public AsyncListener getAsyncListener() {
            return this.listener;
        }

        public ServletRequest getRequest() {
            return this.request;
        }

        public ServletResponse getResponse() {
            return this.response;
        }
    }

    static class Handler
    implements Runnable {
        private final AsyncContextImpl asyncContext;
        private final ApplicationDispatcher dispatcher;

        Handler(AsyncContextImpl asyncContext, ApplicationDispatcher dispatcher) {
            this.asyncContext = asyncContext;
            this.dispatcher = dispatcher;
        }

        public void run() {
            try {
                this.dispatcher.dispatch(this.asyncContext.getRequest(), this.asyncContext.getResponse(), DispatcherType.ASYNC);
                if (!this.asyncContext.getRequest().isAsyncStarted()) {
                    this.asyncContext.complete();
                }
            }
            catch (Throwable t) {
                this.asyncContext.notifyAsyncListeners(AsyncEventType.ERROR, t);
                this.asyncContext.getOriginalRequest().errorDispatchAndComplete(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AsyncEventType {
        COMPLETE,
        TIMEOUT,
        ERROR,
        START_ASYNC;

    }
}

