/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-network-listener")
@Scoped(value=PerLookup.class)
@I18n(value="create.network.listener")
public class CreateNetworkListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateNetworkListener.class);
    @Param(name="address", optional=true)
    String address;
    @Param(name="listenerport", optional=false)
    String port;
    @Param(name="threadpool", optional=true, defaultValue="http-thread-pool")
    String threadPool;
    @Param(name="protocol", optional=false)
    String protocol;
    @Param(name="name", primary=true)
    String listenerName;
    @Param(name="transport", optional=true, defaultValue="tcp")
    String transport;
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="jkenabled", optional=true, defaultValue="false")
    Boolean jkEnabled;
    @Inject
    Configs configs;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        NetworkListeners nls = networkConfig.getNetworkListeners();
        for (NetworkListener networkListener : nls.getNetworkListener()) {
            if (!networkListener.getName().equals(this.listenerName)) continue;
            report.setMessage(localStrings.getLocalString("create.network.listener.fail.duplicate", "Network Listener named {0} already exists.", new Object[]{this.listenerName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.verifyUniquePort(networkConfig)) {
            String def = "Port is already taken by another listener, choose another port.";
            report.setMessage(def);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol protocolObj = networkConfig.findProtocol(this.protocol);
        if (protocolObj.getHttp() == null) {
            report.setMessage(localStrings.getLocalString("create.network.listener.fail.nohttp", "Network Listener named {0} refers to protocol {1} that has no http configured", new Object[]{this.listenerName, this.protocol}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

                public Object run(NetworkListeners param) throws TransactionFailure {
                    NetworkListener newNetworkListener = (NetworkListener)param.createChild(NetworkListener.class);
                    newNetworkListener.setProtocol(CreateNetworkListener.this.protocol);
                    newNetworkListener.setTransport(CreateNetworkListener.this.transport);
                    newNetworkListener.setEnabled(CreateNetworkListener.this.enabled.toString());
                    newNetworkListener.setJkEnabled(CreateNetworkListener.this.jkEnabled.toString());
                    newNetworkListener.setPort(CreateNetworkListener.this.port);
                    newNetworkListener.setThreadPool(CreateNetworkListener.this.threadPool);
                    newNetworkListener.setName(CreateNetworkListener.this.listenerName);
                    newNetworkListener.setAddress(CreateNetworkListener.this.address);
                    param.getNetworkListener().add(newNetworkListener);
                    CreateNetworkListener.this.updateVirtualServer(newNetworkListener);
                    return newNetworkListener;
                }
            }, (ConfigBeanProxy)nls);
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.network.listener.fail", "{0} create failed: " + (e.getMessage() == null ? "No reason given" : e.getMessage()), new Object[]{this.listenerName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void updateVirtualServer(final NetworkListener listener) throws TransactionFailure {
        Protocol prot = listener.findHttpProtocol();
        if (prot != null) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer param) throws PropertyVetoException {
                    param.addNetworkListener(listener.getName());
                    return null;
                }
            }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getComponent(VirtualServer.class, prot.getHttp().getDefaultVirtualServer())));
        }
    }

    private boolean verifyUniquePort(NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.port) || !listener.getAddress().trim().equals(this.address)) continue;
            return false;
        }
        return true;
    }
}

