/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="session-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container Session Statistics")
public class SessionStatsProvider {
    private static final Logger logger = LogDomains.getLogger(SessionStatsProvider.class, (String)"javax.enterprise.system.container.web");
    private static final String ACTIVE_SESSIONS_DESCRIPTION = "Number of active sessions";
    private static final String TOTAL_SESSIONS_DESCRIPTION = "Total number of sessions ever created";
    private static final String EXPIRED_SESSIONS_DESCRIPTION = "Total number of sessions ever expired";
    private static final String REJECTED_SESSIONS_DESCRIPTION = "Total number of sessions ever rejected";
    private static final String PERSISTED_SESSIONS_DESCRIPTION = "Total number of sessions ever persisted";
    private static final String PASSIVATED_SESSIONS_DESCRIPTION = "Total number of sessions ever passivated";
    private static final String ACTIVATED_SESSIONS_DESCRIPTION = "Total number of sessions ever activated";
    private String moduleName;
    private String vsName;
    private RangeStatisticImpl activeSessionsCount;
    private CountStatisticImpl sessionsTotal;
    private CountStatisticImpl expiredSessionsTotal;
    private CountStatisticImpl rejectedSessionsTotal;
    private CountStatisticImpl persistedSessionsTotal;
    private CountStatisticImpl passivatedSessionsTotal;
    private CountStatisticImpl activatedSessionsTotal;

    public SessionStatsProvider(String moduleName, String vsName) {
        this.moduleName = moduleName;
        this.vsName = vsName;
        long curTime = System.currentTimeMillis();
        this.activeSessionsCount = new RangeStatisticImpl(0L, 0L, 0L, "ActiveSessions", "count", ACTIVE_SESSIONS_DESCRIPTION, curTime, curTime);
        this.sessionsTotal = new CountStatisticImpl("SessionsTotal", "count", TOTAL_SESSIONS_DESCRIPTION);
        this.expiredSessionsTotal = new CountStatisticImpl("ExpiredSessionsTotal", "count", EXPIRED_SESSIONS_DESCRIPTION);
        this.rejectedSessionsTotal = new CountStatisticImpl("RejectedSessionsTotal", "count", REJECTED_SESSIONS_DESCRIPTION);
        this.persistedSessionsTotal = new CountStatisticImpl("PersistedSessionsTotal", "count", PERSISTED_SESSIONS_DESCRIPTION);
        this.passivatedSessionsTotal = new CountStatisticImpl("PassivatedSessionsTotal", "count", PASSIVATED_SESSIONS_DESCRIPTION);
        this.activatedSessionsTotal = new CountStatisticImpl("ActivatedSessionsTotal", "count", ACTIVATED_SESSIONS_DESCRIPTION);
    }

    @ManagedAttribute(id="activesessionscount")
    @Description(value="Number of active sessions")
    public RangeStatistic getActiveSessions() {
        return this.activeSessionsCount;
    }

    @ManagedAttribute(id="sessionstotal")
    @Description(value="Total number of sessions ever created")
    public CountStatistic getSessionsTotal() {
        return this.sessionsTotal;
    }

    @ManagedAttribute(id="rejectedsessionstotal")
    @Description(value="Total number of sessions ever rejected")
    public CountStatistic getRejectedSessionsTotal() {
        return this.rejectedSessionsTotal;
    }

    @ManagedAttribute(id="expiredsessionstotal")
    @Description(value="Total number of sessions ever expired")
    public CountStatistic getExpiredSessionsTotal() {
        return this.expiredSessionsTotal;
    }

    @ManagedAttribute(id="persistedsessionstotal")
    @Description(value="Total number of sessions ever persisted")
    public CountStatistic getPersistedSessionsTotal() {
        return this.persistedSessionsTotal;
    }

    @ManagedAttribute(id="passivatedsessionstotal")
    @Description(value="Total number of sessions ever passivated")
    public CountStatistic getPassivatedSessionsTotal() {
        return this.passivatedSessionsTotal;
    }

    @ManagedAttribute(id="activatedsessionstotal")
    @Description(value="Total number of sessions ever activated")
    public CountStatistic getActivatedSessionsTotal() {
        return this.activatedSessionsTotal;
    }

    @ProbeListener(value="glassfish:web:session:sessionCreatedEvent")
    public void sessionCreatedEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionCreatedEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.incrementActiveSessions();
            this.sessionsTotal.increment();
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionDestroyedEvent")
    public void sessionDestroyedEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionDestroyedEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.decrementActiveSessions();
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionRejectedEvent")
    public void sessionRejectedEvent(@ProbeParam(value="maxThresholdSize") int maxSessions, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionRejectedEvent received - max sessions = " + maxSessions + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.rejectedSessionsTotal.increment();
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionExpiredEvent")
    public void sessionExpiredEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionExpiredEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.expiredSessionsTotal.increment();
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionPersistedStartEvent")
    public void sessionPersistedStartEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionPersistedStartEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionPersistedEndEvent")
    public void sessionPersistedEndEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionPersistedEndEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.persistedSessionsTotal.increment();
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionActivatedStartEvent")
    public void sessionActivatedStartEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionActivatedStartEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionActivatedEndEvent")
    public void sessionActivatedEndEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionActivatedEndEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.incrementActiveSessions();
            this.activatedSessionsTotal.increment();
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionPassivatedStartEvent")
    public void sessionPassivatedStartEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionPassivatedStartEvent  received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionPassivatedEndEvent")
    public void sessionPassivatedEndEvent(@ProbeParam(value="sessionId") String sessionId, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]sessionPassivatedEndEvent received - session = " + sessionId + ": appname = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            this.decrementActiveSessions();
            this.passivatedSessionsTotal.increment();
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementActiveSessions() {
        RangeStatisticImpl rangeStatisticImpl = this.activeSessionsCount;
        synchronized (rangeStatisticImpl) {
            this.activeSessionsCount.setCurrent(this.activeSessionsCount.getCurrent() + 1L);
            if (this.activeSessionsCount.getCurrent() > this.activeSessionsCount.getHighWaterMark()) {
                this.activeSessionsCount.setHighWaterMark(this.activeSessionsCount.getCurrent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementActiveSessions() {
        RangeStatisticImpl rangeStatisticImpl = this.activeSessionsCount;
        synchronized (rangeStatisticImpl) {
            this.activeSessionsCount.setCurrent(this.activeSessionsCount.getCurrent() - 1L);
        }
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.activeSessionsCount.setCurrent(0L);
        this.activeSessionsCount.setLowWaterMark(0L);
        this.activeSessionsCount.setHighWaterMark(0L);
        this.sessionsTotal.setCount(0L);
        this.expiredSessionsTotal.setCount(0L);
        this.rejectedSessionsTotal.setCount(0L);
        this.persistedSessionsTotal.setCount(0L);
        this.passivatedSessionsTotal.setCount(0L);
        this.activatedSessionsTotal.setCount(0L);
    }
}

