/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.web.admin.monitor.JspStatsProvider;
import org.glassfish.web.admin.monitor.RequestStatsProvider;
import org.glassfish.web.admin.monitor.ServletInstanceStatsProvider;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.SessionStatsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="web")
@Scoped(value=Singleton.class)
public class WebStatsProviderBootstrap
implements PostConstruct {
    private static final Logger logger = LogDomains.getLogger(WebStatsProviderBootstrap.class, (String)"javax.enterprise.system.container.web");
    private static final String NODE_SEPARATOR = "/";
    @Inject
    private static Domain domain;
    private static HttpService httpService;
    private static NetworkConfig networkConfig;
    private Server server;
    private Map<String, Queue> nameToStatsProviders = new ConcurrentHashMap<String, Queue>();
    private Queue webContainerStatsProviderQueue = new ConcurrentLinkedQueue();

    public void postConstruct() {
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        networkConfig = config.getNetworkConfig();
        this.server = null;
        List ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            this.server = sr;
            break;
        }
        this.registerWebStatsProviders();
    }

    private void registerWebStatsProviders() {
        JspStatsProvider jsp = new JspStatsProvider(null, null);
        RequestStatsProvider wsp = new RequestStatsProvider(null, null);
        ServletStatsProvider svsp = new ServletStatsProvider(null, null);
        SessionStatsProvider sssp = new SessionStatsProvider(null, null);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/jsp", (Object)jsp);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/request", (Object)wsp);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/servlet", (Object)svsp);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/session", (Object)sssp);
        this.webContainerStatsProviderQueue.add(jsp);
        this.webContainerStatsProviderQueue.add(wsp);
        this.webContainerStatsProviderQueue.add(svsp);
        this.webContainerStatsProviderQueue.add(sssp);
    }

    public void registerApplicationStatsProviders(String monitoringName, String vsName, List<String> servletNames) {
        String node = this.getNodeString(monitoringName, vsName);
        ConcurrentLinkedQueue<Object> statspList = this.nameToStatsProviders.get(monitoringName);
        if (statspList == null) {
            statspList = new ConcurrentLinkedQueue<Object>();
        }
        JspStatsProvider jspStatsProvider = new JspStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)jspStatsProvider);
        statspList.add(jspStatsProvider);
        ServletStatsProvider servletStatsProvider = new ServletStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)servletStatsProvider);
        statspList.add(servletStatsProvider);
        SessionStatsProvider sessionStatsProvider = new SessionStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)sessionStatsProvider);
        statspList.add(sessionStatsProvider);
        RequestStatsProvider websp = new RequestStatsProvider(monitoringName, vsName);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)websp);
        for (String servletName : servletNames) {
            ServletInstanceStatsProvider servletInstanceStatsProvider = new ServletInstanceStatsProvider(servletName, monitoringName, vsName);
            StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)this.getNodeString(monitoringName, vsName, servletName), (Object)servletInstanceStatsProvider);
            statspList.add(servletInstanceStatsProvider);
        }
        statspList.add(websp);
        this.nameToStatsProviders.put(monitoringName, statspList);
    }

    public void unregisterApplicationStatsProviders(String monitoringName, String vsName) {
        Queue statsProviders = this.nameToStatsProviders.remove(monitoringName);
        for (Object statsProvider : statsProviders) {
            StatsProviderManager.unregister(statsProvider);
        }
        if (this.nameToStatsProviders.isEmpty()) {
            for (Object statsProvider : this.webContainerStatsProviderQueue) {
                StatsProviderManager.unregister(statsProvider);
            }
            this.webContainerStatsProviderQueue.clear();
        }
    }

    private String getNodeString(String moduleName, String ... others) {
        StringBuffer sb = new StringBuffer(moduleName);
        for (String other : others) {
            sb.append(NODE_SEPARATOR).append(other);
        }
        return sb.toString();
    }

    static {
        httpService = null;
        networkConfig = null;
    }
}

