/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.apache.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainerInitializerUtil {
    private static final Logger log = LogDomains.getLogger(ServletContainerInitializerUtil.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = log.getResourceBundle();

    public static Iterable<ServletContainerInitializer> getServletContainerInitializers(Map<String, String> webFragmentMap, List<String> absoluteOrderingList, boolean hasOthers, ClassLoader cl) {
        if (absoluteOrderingList != null && !hasOthers) {
            if (!(cl instanceof URLClassLoader)) {
                log.log(Level.WARNING, "servletContainerInitializerUtil.wrongClassLoaderType", cl.getClass().getCanonicalName());
                return null;
            }
            URLClassLoader webAppCl = (URLClassLoader)cl;
            ArrayList<URL> newClassLoaderUrlList = new ArrayList<URL>();
            for (URL classLoaderUrl : webAppCl.getURLs()) {
                String path;
                if (!"file".equals(classLoaderUrl.getProtocol())) continue;
                File file = new File(Util.URLDecode((String)classLoaderUrl.getFile()));
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!file.exists() || !(path = file.getAbsolutePath()).endsWith(".jar") || ServletContainerInitializerUtil.isFragmentMissingFromAbsoluteOrdering(file.getName(), webFragmentMap, absoluteOrderingList)) continue;
                newClassLoaderUrlList.add(classLoaderUrl);
            }
            URL[] urlsForNewClassLoader = new URL[newClassLoaderUrlList.size()];
            cl = new URLClassLoader(newClassLoaderUrlList.toArray(urlsForNewClassLoader), webAppCl.getParent());
        }
        return ServiceLoader.load(ServletContainerInitializer.class, cl);
    }

    public static Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> getInterestList(Iterable<ServletContainerInitializer> initializers) {
        if (null == initializers) {
            return null;
        }
        HashMap interestList = null;
        for (ServletContainerInitializer sc : initializers) {
            HandlesTypes ann;
            if (interestList == null) {
                interestList = new HashMap();
            }
            if ((ann = sc.getClass().getAnnotation(HandlesTypes.class)) == null) {
                ArrayList currentInitializerList = (ArrayList)interestList.get(ServletContainerInitializerUtil.class);
                if (currentInitializerList == null) {
                    ArrayList arr = new ArrayList();
                    arr.add(sc.getClass());
                    interestList.put(ServletContainerInitializerUtil.class, arr);
                    continue;
                }
                currentInitializerList.add(sc.getClass());
                continue;
            }
            Class[] interestedClasses = ann.value();
            if (interestedClasses == null || interestedClasses.length == 0) continue;
            for (Class c : interestedClasses) {
                ArrayList currentInitializerList = (ArrayList)interestList.get(c);
                if (currentInitializerList == null) {
                    ArrayList arr = new ArrayList();
                    arr.add(sc.getClass());
                    interestList.put(c, arr);
                    continue;
                }
                currentInitializerList.add(sc.getClass());
            }
        }
        return interestList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> getInitializerList(Iterable<ServletContainerInitializer> initializers, Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList, ClassLoader cl) {
        if (interestList == null) {
            return null;
        }
        Map<Class<Object>, HashSet<Class<?>>> initializerList = null;
        if (interestList.containsKey(ServletContainerInitializerUtil.class)) {
            initializerList = new HashMap();
            ArrayList<Class<? extends ServletContainerInitializer>> initializersWithoutHandleTypes = interestList.get(ServletContainerInitializerUtil.class);
            for (Class<? extends ServletContainerInitializer> c : initializersWithoutHandleTypes) {
                initializerList.put(c, null);
            }
        }
        if (interestList.keySet().size() > 1 || interestList.keySet().size() == 1 && !interestList.containsKey(ServletContainerInitializerUtil.class)) {
            for (URL u : ((URLClassLoader)cl).getURLs()) {
                String path = Util.URLDecode((String)u.getPath());
                try {
                    if (path.endsWith(".jar")) {
                        JarFile jf = new JarFile(path);
                        try {
                            Enumeration<JarEntry> entries = jf.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry anEntry = entries.nextElement();
                                if (anEntry.isDirectory() || !anEntry.getName().endsWith(".class")) continue;
                                try {
                                    String className = anEntry.getName().replace('/', '.');
                                    className = className.substring(0, className.length() - 6);
                                    Class<?> aClass = cl.loadClass(className);
                                    initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(aClass, interestList, initializerList);
                                }
                                catch (Throwable t) {
                                    if (!log.isLoggable(Level.FINEST)) continue;
                                    log.log(Level.FINEST, "servletContainerInitializerUtil.classLoadingError", new Object[]{anEntry.getName(), t.toString()});
                                }
                            }
                            continue;
                        }
                        finally {
                            jf.close();
                        }
                    }
                    File file = new File(path);
                    if (!file.exists()) continue;
                    if (file.isDirectory()) {
                        initializerList = ServletContainerInitializerUtil.scanDirectory(file, path, cl, interestList, initializerList);
                        continue;
                    }
                    log.log(Level.WARNING, "servletContainerInitializerUtil.invalidUrlClassLoaderPath", path);
                }
                catch (IOException ioex) {
                    String msg = rb.getString("servletContainerInitializerUtil.ioError");
                    msg = MessageFormat.format(msg, path);
                    log.log(Level.SEVERE, msg, ioex);
                    return null;
                }
            }
        }
        for (ServletContainerInitializer initializer : initializers) {
            if (initializerList.containsKey(initializer.getClass())) continue;
            initializerList.put(initializer.getClass(), null);
        }
        return initializerList;
    }

    private static boolean isFragmentMissingFromAbsoluteOrdering(String jarName, Map<String, String> webFragmentMap, List<String> absoluteOrderingList) {
        return webFragmentMap != null && absoluteOrderingList != null && !absoluteOrderingList.contains(webFragmentMap.get(jarName));
    }

    private static String getClassNameFromPath(String fullPath, String top) {
        String className = fullPath.substring(new File(top).getPath().length() + File.separator.length());
        className = className.replace(File.separatorChar, '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private static Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> scanDirectory(File dir, String path, ClassLoader cl, Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> initializerList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                try {
                    Class<?> aClass = cl.loadClass(ServletContainerInitializerUtil.getClassNameFromPath(fileName, path));
                    initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(aClass, interestList, initializerList);
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "servletContainerInitializerUtil.classLoadingError", new Object[]{fileName, t.toString()});
                }
                continue;
            }
            initializerList = ServletContainerInitializerUtil.scanDirectory(file, path, cl, interestList, initializerList);
        }
        return initializerList;
    }

    private static Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> checkAgainstInterestList(Class aClass, Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, HashSet<Class<?>>> initializerList) {
        for (Class<?> c : interestList.keySet()) {
            if (aClass.getAnnotation(c) == null && !c.isAssignableFrom(aClass)) continue;
            if (initializerList == null) {
                initializerList = new HashMap();
            }
            ArrayList<Class<? extends ServletContainerInitializer>> containerInitializers = interestList.get(c);
            for (Class<? extends ServletContainerInitializer> initializer : containerInitializers) {
                HashSet<Class<Object>> classSet = initializerList.get(initializer);
                if (classSet == null) {
                    classSet = new HashSet();
                }
                classSet.add(aClass);
                initializerList.put(initializer, classSet);
            }
        }
        return initializerList;
    }
}

