/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.web.cache.CacheManager;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.WebValidatorWithCL;
import com.sun.enterprise.web.CacheModule;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.jsp.JspProbeEmitterImpl;
import com.sun.enterprise.web.jsp.ResourceInjectorImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.glassfish.api.web.TldProvider;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.component.Habitat;

final class WebModuleListener
implements LifecycleListener {
    private static final Logger _logger = LogDomains.getLogger(WebModuleListener.class, (String)"javax.enterprise.system.container.web");
    private static boolean _debugLog = _logger.isLoggable(Level.FINE);
    private WebBundleDescriptor wbd;
    private File explodedLocation;
    private WebContainer webContainer;

    public WebModuleListener(WebContainer webContainer, File explodedLocation, WebBundleDescriptor wbd) {
        this.webContainer = webContainer;
        this.wbd = wbd;
        this.explodedLocation = explodedLocation;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        WebModule webModule;
        try {
            webModule = (WebModule)event.getLifecycle();
        }
        catch (ClassCastException e) {
            _logger.log(Level.WARNING, "webmodule.listener.classcastException", event.getLifecycle());
            return;
        }
        if (event.getType().equals("start")) {
            if (this.wbd != null && this.wbd.getApplication() != null && this.wbd.getApplication().isVirtual()) {
                this.wbd.setClassLoader(webModule.getLoader().getClassLoader());
                this.wbd.visit((WebBundleVisitor)new WebValidatorWithCL());
            }
            this.configureDefaultServlet(webModule);
            this.configureJsp(webModule);
            this.startCacheManager(webModule);
        } else if (event.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    private void configureJsp(WebModule webModule) {
        webModule.getServletContext().setAttribute("org.glassfish.jsp.isStandaloneWebapp", (Object)new Boolean(webModule.isStandalone()));
        Collection<TldProvider> tldProviders = this.webContainer.getTldProviders();
        HashMap tldMap = new HashMap();
        for (TldProvider tldProvider : tldProviders) {
            Map tmap;
            if ("jsfTld".equals(tldProvider.getName()) && !webModule.isJsfApplication() || (tmap = tldProvider.getTldMap()) == null) continue;
            tldMap.putAll(tmap);
        }
        webModule.getServletContext().setAttribute("com.sun.appserv.tld.map", tldMap);
        HashMap tldListenerMap = new HashMap();
        for (TldProvider tldProvider : tldProviders) {
            Map tmap;
            if ("jsfTld".equals(tldProvider.getName()) && !webModule.isJsfApplication() || (tmap = tldProvider.getTldListenerMap()) == null) continue;
            tldListenerMap.putAll(tmap);
        }
        webModule.getServletContext().setAttribute("com.sun.appserv.tldlistener.map", tldListenerMap);
        webModule.getServletContext().setAttribute("org.glassfish.servlet.habitat", (Object)this.webContainer.getServerContext().getDefaultHabitat());
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        Wrapper wrapper = (Wrapper)webModule.findChild("jsp");
        if (wrapper == null) {
            return;
        }
        if (webModule.getTldValidation()) {
            wrapper.addInitParameter("enableTldValidation", "true");
        }
        if (bean != null && bean.getJspConfig() != null) {
            WebProperty[] props = bean.getJspConfig().getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String pname = props[i].getAttributeValue("name");
                String pvalue = props[i].getAttributeValue("value");
                if (_debugLog) {
                    _logger.fine("jsp-config property for [" + webModule.getID() + "] is [" + pname + "] = [" + pvalue + "]");
                }
                wrapper.addInitParameter(pname, pvalue);
            }
        }
        wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
        ResourceInjectorImpl resourceInjector = new ResourceInjectorImpl();
        resourceInjector.setContext(webModule.getServletContext());
        webModule.getServletContext().setAttribute("com.sun.appserv.jsp.resource.injector", (Object)resourceInjector);
        String sysClassPath = ASClassLoaderUtil.getModuleClassPath((Habitat)this.webContainer.getServerContext().getDefaultHabitat(), (String)webModule.getID(), null);
        Boolean useMyFaces = (Boolean)webModule.getServletContext().getAttribute("com.sun.faces.useMyFaces");
        if (useMyFaces != null && useMyFaces.booleanValue()) {
            sysClassPath = sysClassPath.replace("jsf-api.jar", "$disabled$.raj");
            sysClassPath = sysClassPath.replace("jsf-impl.jar", "$disabled$.raj");
            sysClassPath = sysClassPath.replace("jsf-connector.jar", "$disabled$.raj");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(" sysClasspath for " + webModule.getID() + " is \n" + sysClassPath + "\n");
        }
        if (sysClassPath.equals("")) {
            sysClassPath = System.getProperty("java.class.path");
        }
        wrapper.addInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
        webModule.getServletContext().setAttribute("org.glassfish.jsp.monitor.probeEmitter", (Object)new JspProbeEmitterImpl(webModule));
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level == null) {
            return "warning";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        if (bean != null) {
            CacheManager cm = null;
            try {
                cm = CacheModule.configureResponseCache(webModule, bean);
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, "webmodule.listener.cachemgrException", ee);
            }
            if (cm != null) {
                try {
                    cm.start();
                    if (_debugLog) {
                        _logger.fine("Cache Manager started");
                    }
                    ServletContext ctxt = webModule.getServletContext();
                    ctxt.setAttribute("com.sun.appserv.web.CacheManager", (Object)cm);
                }
                catch (LifecycleException ee) {
                    _logger.log(Level.WARNING, ee.getMessage(), ee.getCause());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext ctxt = webModule.getServletContext();
        CacheManager cm = (CacheManager)ctxt.getAttribute("com.sun.appserv.web.CacheManager");
        if (cm != null) {
            try {
                cm.stop();
                if (_debugLog) {
                    _logger.fine("Cache Manager stopped");
                }
                ctxt.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException ee) {
                _logger.log(Level.WARNING, ee.getMessage(), ee.getCause());
            }
        }
    }

    private void configureDefaultServlet(WebModule webModule) {
        Wrapper wrapper = (Wrapper)webModule.findChild("default");
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClassName();
        if (servletClass == null || !servletClass.equals(Globals.DEFAULT_SERVLET_CLASS_NAME)) {
            return;
        }
        String fileEncoding = webModule.getFileEncoding();
        if (fileEncoding != null) {
            wrapper.addInitParameter("fileEncoding", fileEncoding);
        }
    }
}

