/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-protocol")
@Scoped(value=PerLookup.class)
@I18n(value="delete.protocol")
public class DeleteProtocol
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProtocol.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    Protocol protocol = null;
    @Inject
    Configs configs;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            this.protocol = (Protocol)this.habitat.getComponent(Protocol.class, this.protocolName);
            if (this.protocol == null) {
                report.setMessage(localStrings.getLocalString("delete.protocol.notexists", "{0} protocol doesn't exist", new Object[]{this.protocolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List nwlsnrList = this.protocol.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.protocol.getName().equals(nwlsnr.getProtocol())) continue;
                report.setMessage(localStrings.getLocalString("delete.protocol.beingused", "{0} protocol is being used in the network listener {1}", new Object[]{this.protocolName, nwlsnr.getName()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws PropertyVetoException, TransactionFailure {
                    param.getProtocol().remove(DeleteProtocol.this.protocol);
                    return DeleteProtocol.this.protocol;
                }
            }, (ConfigBeanProxy)protocols);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.protocol.fail", "Deletion of Protocol {0} failed", new Object[]{this.protocolName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

