/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.appserv.BytecodePreprocessor;
import com.sun.appserv.ClassLoaderUtil;
import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.logging.LogDomains;
import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.BeanELResolver;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.web.loader.Reloader;
import org.glassfish.web.loader.ResourceEntry;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappClassLoader
extends URLClassLoader
implements Reloader,
InstrumentableClassLoader,
PreDestroy {
    private static final Logger logger = LogDomains.getLogger(WebappClassLoader.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final String[] packageTriggers = new String[]{"javax", "sun", "org.xml.sax", "org.w3c.dom", "org.apache.taglibs.standard", "com.sun.faces", "org.apache.commons.logging"};
    public static final boolean ENABLE_CLEAR_REFERENCES = Boolean.valueOf(System.getProperty("org.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES", "true"));
    private static final Permission ALL_PERMISSION = new AllPermission();
    private boolean packageDefinitionEnabled = System.getProperty("package.definition") != null;
    protected DirContext resources = null;
    protected ConcurrentHashMap<String, ResourceEntry> resourceEntries = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> notFoundResources = new ConcurrentHashMap();
    protected int debug = 0;
    protected boolean delegate = false;
    protected long lastJarAccessed = 0L;
    protected String[] repositories = new String[0];
    protected URL[] repositoryURLs = null;
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected List<String> jarNames = new ArrayList<String>();
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    private ConcurrentLinkedQueue<Permission> permissionList = new ConcurrentLinkedQueue();
    private File loaderDir = null;
    private ConcurrentHashMap<String, PermissionCollection> loaderPC = new ConcurrentHashMap();
    private SecurityManager securityManager = null;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    private ConcurrentLinkedQueue<BytecodePreprocessor> byteCodePreprocessors = new ConcurrentLinkedQueue();
    private boolean useMyFaces;
    private ConcurrentLinkedQueue<String> overridablePackages;

    public WebappClassLoader() {
        super(new URL[0]);
        this.init();
    }

    public WebappClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.init();
    }

    public WebappClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                super.addURL(this.escapePlus(url));
            }
        }
        this.init();
    }

    public synchronized void addOverridablePackage(String packageName) {
        if (this.overridablePackages == null) {
            this.overridablePackages = new ConcurrentLinkedQueue();
        }
        this.overridablePackages.add(packageName);
    }

    public DirContext getResources() {
        return this.resources;
    }

    public void setResources(DirContext resources) {
        this.resources = resources;
    }

    public ConcurrentHashMap<String, ResourceEntry> getResourceEntries() {
        return this.resourceEntries;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public void addPermission(String path) {
        if (path == null) {
            return;
        }
        if (this.securityManager != null) {
            FilePermission permission = null;
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                permission = new JndiPermission(path + "*");
                this.addPermission(permission);
            } else {
                if (!path.endsWith(File.separator)) {
                    permission = new FilePermission(path, "read");
                    this.addPermission(permission);
                    path = path + File.separator;
                }
                permission = new FilePermission(path + "-", "read");
                this.addPermission(permission);
            }
        }
    }

    public void addPermission(URL url) {
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setWorkDir(File workDir) {
        this.loaderDir = new File(workDir, "loader_" + this.hashCode());
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
        if (useMyFaces) {
            this.addOverridablePackage("javax.faces");
            this.addOverridablePackage("com.sun.faces");
        }
    }

    @Override
    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            this.addRepository(new URL(repository));
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid repository: " + repository);
            iae.initCause(e);
            throw iae;
        }
    }

    public void addRepository(URL url) {
        super.addURL(this.escapePlus(url));
        this.hasExternalRepositories = true;
    }

    public synchronized void addRepository(String repository, File file) {
        int i;
        if (repository == null) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("addRepository(" + repository + ")");
        }
        String[] result = new String[this.repositories.length + 1];
        for (i = 0; i < this.repositories.length; ++i) {
            result[i] = this.repositories[i];
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        for (i = 0; i < this.files.length; ++i) {
            result2[i] = this.files[i];
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    public synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        int i;
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("addJar(" + jar + ")");
        }
        if (this.jarPath != null && jar.startsWith(this.jarPath)) {
            String jarName = jar.substring(this.jarPath.length());
            while (jarName.startsWith("/")) {
                jarName = jarName.substring(1);
            }
            this.jarNames.add(jarName);
        }
        try {
            long lastModified = ((ResourceAttributes)this.resources.getAttributes(jar)).getLastModified();
            String[] result = new String[this.paths.length + 1];
            for (i = 0; i < this.paths.length; ++i) {
                result[i] = this.paths[i];
            }
            result[this.paths.length] = jar;
            this.paths = result;
            long[] result3 = new long[this.lastModifiedDates.length + 1];
            for (i = 0; i < this.lastModifiedDates.length; ++i) {
                result3[i] = this.lastModifiedDates[i];
            }
            result3[this.lastModifiedDates.length] = lastModified;
            this.lastModifiedDates = result3;
        }
        catch (NamingException e) {
            // empty catch block
        }
        JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
        for (i = 0; i < this.jarFiles.length; ++i) {
            result2[i] = this.jarFiles[i];
        }
        result2[this.jarFiles.length] = jarFile;
        this.jarFiles = result2;
        File[] result4 = new File[this.jarRealFiles.length + 1];
        for (i = 0; i < this.jarRealFiles.length; ++i) {
            result4[i] = this.jarRealFiles[i];
        }
        result4[this.jarRealFiles.length] = file;
        this.jarRealFiles = result4;
    }

    @Override
    public boolean modified() {
        int length2;
        int length;
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("modified()");
        }
        if ((length = this.paths.length) > (length2 = this.lastModifiedDates.length)) {
            length = length2;
        }
        for (int i = 0; i < length; ++i) {
            try {
                long lastModified = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (lastModified == this.lastModifiedDates[i]) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  Resource '" + this.paths[i] + "' was modified; Date is now: " + new Date(lastModified) + " Was: " + new Date(this.lastModifiedDates[i]));
                }
                return true;
            }
            catch (NamingException e) {
                logger.severe("    Resource '" + this.paths[i] + "' is missing");
                return true;
            }
        }
        length = this.jarNames.size();
        if (this.getJarPath() != null) {
            try {
                String name;
                NameClassPair ncPair;
                NamingEnumeration<Binding> enumeration = this.resources.listBindings(this.getJarPath());
                int i = 0;
                while (enumeration.hasMoreElements() && i < length) {
                    ncPair = (NameClassPair)enumeration.nextElement();
                    name = ncPair.getName();
                    if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                    if (!name.equals(this.jarNames.get(i))) {
                        logger.finer("    Additional JARs have been added : '" + name + "'");
                        return true;
                    }
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        ncPair = (NameClassPair)enumeration.nextElement();
                        name = ncPair.getName();
                        if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                        logger.finer("    Additional JARs have been added");
                        return true;
                    }
                } else if (i < this.jarNames.size()) {
                    logger.finer("    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("    Failed tracking modifications of '" + this.getJarPath() + "'");
                }
            }
            catch (ClassCastException e) {
                logger.severe("    Failed tracking modifications of '" + this.getJarPath() + "' : " + e.getMessage());
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("WebappClassLoader (delegate=");
        sb.append(this.delegate);
        if (this.repositories != null) {
            sb.append("; repositories=");
            for (int i = 0; i < this.repositories.length; ++i) {
                sb.append(this.repositories[i]);
                if (i == this.repositories.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("    findClass(" + name + ")");
        }
        if (this.securityManager != null && this.packageDefinitionEnabled && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("      findClassInternal(" + name + ")");
            }
            try {
                ResourceEntry entry = this.findClassInternal(name);
                CodeSource codeSource = new CodeSource(entry.codeBase, entry.certificates);
                WebappClassLoader webappClassLoader = this;
                synchronized (webappClassLoader) {
                    if (entry.loadedClass == null) {
                        byte[] binaryContent = entry.binaryContent;
                        if (!this.byteCodePreprocessors.isEmpty()) {
                            String resourceName = name.replace('.', '/') + ".class";
                            for (BytecodePreprocessor preprocessor : this.byteCodePreprocessors) {
                                binaryContent = preprocessor.preprocess(resourceName, binaryContent);
                            }
                        }
                        clazz = this.defineClass(name, binaryContent, 0, binaryContent.length, codeSource);
                        entry.loadedClass = clazz;
                        entry.binaryContent = null;
                        entry.source = null;
                        entry.codeBase = null;
                        entry.manifest = null;
                        entry.certificates = null;
                    } else {
                        clazz = entry.loadedClass;
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.hasExternalRepositories) {
                    throw cnfe;
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                String msg = rb.getString("webappClassLoader.unsupportedVersion");
                msg = MessageFormat.format(msg, name, this.getJavaVersion());
                throw new UnsupportedClassVersionError(msg);
            }
            catch (AccessControlException ace) {
                throw new ClassNotFoundException(name, ace);
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Error err) {
                throw err;
            }
            catch (Throwable t) {
                String msg = rb.getString("webappClassLoader.unableToLoadClass");
                msg = MessageFormat.format(msg, name, t.toString());
                throw new RuntimeException(msg, t);
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    WebappClassLoader t = this;
                    synchronized (t) {
                        clazz = super.findClass(name);
                    }
                }
                catch (AccessControlException ace) {
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "      -->RuntimeException Rethrown", e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("    --> Passing on ClassNotFoundException");
            }
            throw e;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("      Returning class " + clazz);
        }
        if (logger.isLoggable(Level.FINER) && clazz != null) {
            ClassLoader cl = this.securityManager != null ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            logger.finer("      Loaded by " + cl);
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        ResourceEntry entry;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("    findResource(" + name + ")");
        }
        URL url = null;
        if (".".equals(name)) {
            name = "";
        }
        if ((entry = this.resourceEntries.get(name)) == null) {
            entry = this.findResourceInternal(name, name);
        }
        if (entry != null) {
            url = entry.source;
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        if (logger.isLoggable(Level.FINER)) {
            if (url != null) {
                logger.finer("    --> Returning '" + url.toString() + "'");
            } else {
                logger.finer("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        int i;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("    findResources(" + name + ")");
        }
        Vector<URL> result = new Vector<URL>();
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        for (i = 0; i < repositoriesLength; ++i) {
            try {
                String fullPath = this.repositories[i] + name;
                this.resources.lookup(fullPath);
                try {
                    result.addElement(this.getURI(new File(this.files[i], name)));
                }
                catch (MalformedURLException e) {}
                continue;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        JarFile[] e = this.jarFiles;
        synchronized (this.jarFiles) {
            if (this.openJARs()) {
                for (i = 0; i < jarFilesLength; ++i) {
                    JarEntry jarEntry = this.jarFiles[i].getJarEntry(name);
                    if (jarEntry == null) continue;
                    try {
                        String jarFakeUrl = this.getURI(this.jarRealFiles[i]).toString();
                        jarFakeUrl = "jar:" + jarFakeUrl + "!/" + name;
                        result.addElement(new URL(jarFakeUrl));
                        continue;
                    }
                    catch (MalformedURLException e2) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (this.hasExternalRepositories) {
                Enumeration<URL> otherResourcePaths = super.findResources(name);
                while (otherResourcePaths.hasMoreElements()) {
                    result.addElement(otherResourcePaths.nextElement());
                }
            }
            return result.elements();
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoader loader;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("getResource(" + name + ")");
        }
        URL url = null;
        if (this.delegate || name.startsWith("javax") && (!name.startsWith("javax.faces") || !this.useMyFaces) || name.startsWith("sun") || name.startsWith("com/sun/faces") && !name.startsWith("com/sun/faces/extensions") && !this.useMyFaces || name.startsWith("org/apache/taglibs/standard")) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Delegating to parent classloader " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            ResourceEntry entry = this.resourceEntries.get(name);
            try {
                String repository = entry.codeBase.toString();
                if (repository.endsWith(".jar") && !name.endsWith(".class") && !name.endsWith(".jar")) {
                    File resourceFile = new File(this.loaderDir, name);
                    url = resourceFile.toURL();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("getResourceAsStream(" + name + ")");
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate || name.startsWith("javax") || name.startsWith("sun") || name.startsWith("com/sun/faces") && !name.startsWith("com/sun/faces/extensions") || name.startsWith("org/apache/taglibs/standard")) {
            ClassLoader loader;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Delegating to parent classloader " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Delegating to parent classloader unconditionally " + this.parent);
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final Enumeration[] enums = new Enumeration[2];
        Enumeration<URL> localResources = this.findResources(name);
        Enumeration<URL> parentResources = null;
        parentResources = this.parent != null ? this.parent.getResources(name) : this.system.getResources(name);
        if (this.delegate) {
            enums[0] = parentResources;
            enums[1] = localResources;
        } else {
            enums[0] = localResources;
            enums[1] = parentResources;
        }
        return new Enumeration(){
            int index = 0;

            private boolean next() {
                while (this.index < enums.length) {
                    if (enums[this.index] != null && enums[this.index].hasMoreElements()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                return (URL)enums[this.index].nextElement();
            }
        };
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader delegateLoader;
        int i;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("loadClass(" + name + ")");
        }
        Class<?> clazz = null;
        if (!this.started) {
            String msg = rb.getString("webappClassLoader.notStarted");
            throw new IllegalStateException(MessageFormat.format(msg, name));
        }
        clazz = this.findLoadedClass0(name);
        if (clazz != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Returning class from cache");
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Returning class from cache");
            }
            return clazz;
        }
        if (this.securityManager != null && this.packageDefinitionEnabled && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                logger.log(Level.INFO, error, se);
                throw new ClassNotFoundException(error, se);
            }
        }
        if ((delegateLoader = this.parent) == null) {
            delegateLoader = this.system;
        }
        if (this.delegate) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Delegating to classloader1 " + delegateLoader);
            }
            try {
                clazz = delegateLoader.loadClass(name);
                if (clazz != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("  Loading class from delegate");
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Searching local repositories");
            }
            if ((clazz = this.findClass(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  Loading class from local repository");
                }
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        boolean filterCoreClasses = this.filter(name);
        if (!filterCoreClasses) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Searching local repositories");
            }
            try {
                clazz = this.findClass(name);
                if (clazz != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("  Loading class from local repository");
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("  Delegating to classloader " + delegateLoader);
        }
        try {
            clazz = delegateLoader.loadClass(name);
            if (clazz != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  Loading class from delegate");
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (filterCoreClasses) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("  Searching local repositories");
            }
            if ((clazz = this.findClass(name)) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("  Loading class from local repository");
                }
                return clazz;
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.loadClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            for (Permission p : this.permissionList) {
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    @Override
    public URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return this.repositoryURLs;
        }
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int length = filesLength + jarFilesLength + external.length;
        try {
            URL[] urls = new URL[length];
            for (int i = 0; i < length; ++i) {
                urls[i] = i < filesLength ? this.getURL(this.files[i]) : (i < filesLength + jarFilesLength ? this.getURL(this.jarRealFiles[i - filesLength]) : external[i - filesLength - jarFilesLength]);
            }
            this.repositoryURLs = urls;
        }
        catch (MalformedURLException e) {
            this.repositoryURLs = new URL[0];
        }
        return this.repositoryURLs;
    }

    private void init() {
        this.parent = this.getParent();
        this.system = this.getClass().getClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
        this.addOverridablePackage("com.sun.faces.extensions");
    }

    public void start() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void preDestroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        int i;
        if (!this.started) {
            return;
        }
        this.purgeELBeanClasses();
        ClassLoader curCl = null;
        try {
            curCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this);
            this.clearReferences();
        }
        finally {
            if (curCl != null) {
                Thread.currentThread().setContextClassLoader(curCl);
            }
        }
        ClassLoaderUtil.releaseLoader((URLClassLoader)this);
        this.started = false;
        int length = this.files.length;
        for (i = 0; i < length; ++i) {
            this.files[i] = null;
        }
        length = this.jarFiles.length;
        for (i = 0; i < length; ++i) {
            try {
                if (this.jarFiles[i] != null) {
                    this.jarFiles[i].close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.jarFiles[i] = null;
        }
        try {
            Method m;
            Class<?> clazz = Class.forName("sun.misc.ClassLoaderUtil");
            if (clazz != null && (m = clazz.getMethod("releaseLoader", URLClassLoader.class)) != null) {
                m.invoke(null, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.resources = null;
        this.repositories = null;
        this.repositoryURLs = null;
        this.files = null;
        this.jarFiles = null;
        this.jarRealFiles = null;
        this.jarPath = null;
        this.jarNames.clear();
        this.lastModifiedDates = null;
        this.paths = null;
        this.hasExternalRepositories = false;
        this.parent = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        if (this.loaderDir != null) {
            WebappClassLoader.deleteDir(this.loaderDir);
        }
        DirContextURLStreamHandler.unbind((ClassLoader)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeJARs(boolean force) {
        if (this.jarFiles.length <= 0) return;
        JarFile[] jarFileArray = this.jarFiles;
        synchronized (this.jarFiles) {
            if (!force && System.currentTimeMillis() <= this.lastJarAccessed + 90000L) return;
            for (int i = 0; i < this.jarFiles.length; ++i) {
                try {
                    if (this.jarFiles[i] == null) continue;
                    this.jarFiles[i].close();
                    this.jarFiles[i] = null;
                    continue;
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Failed to close JAR", e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearReferences() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != this) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "webappClassLoader.sqlDriverDeregistrationError", e);
            }
        }
        if (ENABLE_CLEAR_REFERENCES) {
            int i;
            Field[] fields;
            Class<?> clazz;
            Collection<ResourceEntry> values = this.resourceEntries.values();
            block15: for (ResourceEntry entry : values) {
                clazz = null;
                WebappClassLoader webappClassLoader = this;
                synchronized (webappClassLoader) {
                    clazz = entry.loadedClass;
                }
                if (clazz == null) continue;
                try {
                    fields = clazz.getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        if (!Modifier.isStatic(fields[i].getModifiers())) continue;
                        fields[i].get(null);
                        continue block15;
                    }
                }
                catch (Throwable t) {
                }
            }
            for (ResourceEntry entry : values) {
                clazz = null;
                WebappClassLoader t = this;
                synchronized (t) {
                    clazz = entry.loadedClass;
                }
                if (clazz == null) continue;
                try {
                    fields = clazz.getDeclaredFields();
                    for (i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        int mods = field.getModifiers();
                        if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1 || !Modifier.isStatic(mods)) continue;
                        try {
                            field.setAccessible(true);
                            if (Modifier.isFinal(mods)) {
                                if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                                this.nullInstance(field.get(null));
                                continue;
                            }
                            field.set(null, null);
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("Set field " + field.getName() + " to null in class " + clazz.getName());
                            continue;
                        }
                        catch (Throwable t2) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, "Could not set field " + field.getName() + " to null in class " + clazz.getName(), t2);
                        }
                    }
                }
                catch (Throwable t2) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Could not clean fields for class " + clazz.getName(), t2);
                }
            }
        }
        Introspector.flushCaches();
    }

    protected void nullInstance(Object instance) {
        if (instance == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1) continue;
            try {
                field.setAccessible(true);
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) continue;
                Object value = field.get(instance);
                if (null != value) {
                    Class<?> valueClass = value.getClass();
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Not setting field " + field.getName() + " to null in object of class " + instance.getClass().getName() + " because the referenced object was of type " + valueClass.getName() + " which was not loaded by this WebappClassLoader.");
                    continue;
                }
                field.set(instance, null);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Set field " + field.getName() + " to null in class " + instance.getClass().getName());
                continue;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName(), t);
            }
        }
    }

    protected boolean loadedByThisOrChild(Class<? extends Object> clazz) {
        boolean result = false;
        for (ClassLoader classLoader = clazz.getClassLoader(); null != classLoader; classLoader = classLoader.getParent()) {
            if (!classLoader.equals(this)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean openJARs() {
        if (this.started && this.jarFiles.length > 0) {
            this.lastJarAccessed = System.currentTimeMillis();
            if (this.jarFiles[0] == null) {
                for (int i = 0; i < this.jarFiles.length; ++i) {
                    try {
                        this.jarFiles[i] = new JarFile(this.jarRealFiles[i]);
                        continue;
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Failed to open JAR", e);
                        }
                        for (int j = 0; j < i; ++j) {
                            try {
                                this.jarFiles[j].close();
                                continue;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = tempPath + ".class";
        ResourceEntry entry = this.findResourceInternal(name, classPath);
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            Class<?> clazz = entry.loadedClass;
            if (clazz != null) {
                return entry;
            }
            if (entry.binaryContent == null) {
                throw new ClassNotFoundException(name);
            }
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            packageName = name.substring(0, pos);
        }
        Package pkg = null;
        if (packageName != null) {
            ConcurrentHashMap<String, PermissionCollection> concurrentHashMap = this.loaderPC;
            synchronized (concurrentHashMap) {
                pkg = this.getPackage(packageName);
                if (pkg == null) {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
            }
        }
        if (this.securityManager != null && pkg != null) {
            boolean sealCheck = true;
            if (pkg.isSealed()) {
                sealCheck = pkg.isSealed(entry.codeBase);
            } else {
                boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
            }
            if (!sealCheck) {
                throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
            }
        }
        return entry;
    }

    private ResourceEntry findResourceInternal(File file, String path) {
        ResourceEntry entry = new ResourceEntry();
        try {
            entry.source = this.getURI(new File(file, path));
            entry.codeBase = this.getURL(new File(file, path));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        if (!this.started) {
            String msg = rb.getString("webappClassLoader.notStarted");
            throw new IllegalStateException(MessageFormat.format(msg, name));
        }
        if (name == null) return null;
        if (path == null) {
            return null;
        }
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry;
        }
        if (this.notFoundResources.containsKey(name)) {
            return null;
        }
        entry = this.findResourceInternalFromRepositories(name, path);
        if (entry == null) {
            JarFile[] jarFileArray = this.jarFiles;
            // MONITORENTER : this.jarFiles
            entry = this.findResourceInternalFromJars(name, path);
            // MONITOREXIT : jarFileArray
        }
        if (entry == null) {
            this.notFoundResources.put(name, name);
            return null;
        }
        ResourceEntry entry2 = this.resourceEntries.putIfAbsent(name, entry);
        if (entry2 == null) return entry;
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceEntry findResourceInternalFromRepositories(String name, String path) {
        ResourceEntry entry = null;
        int contentLength = -1;
        InputStream binaryStream = null;
        int repositoriesLength = this.repositories.length;
        Resource resource = null;
        for (int i = 0; entry == null && i < repositoriesLength; ++i) {
            try {
                String fullPath = this.repositories[i] + path;
                Object lookupResult = this.resources.lookup(fullPath);
                if (lookupResult instanceof Resource) {
                    resource = (Resource)lookupResult;
                }
                if (this.securityManager != null) {
                    PrivilegedFindResource dp = new PrivilegedFindResource(this.files[i], path);
                    entry = AccessController.doPrivileged(dp);
                } else {
                    entry = this.findResourceInternal(this.files[i], path);
                }
                ResourceAttributes attributes = (ResourceAttributes)this.resources.getAttributes(fullPath);
                contentLength = (int)attributes.getContentLength();
                entry.lastModified = attributes.getLastModified();
                if (resource == null) continue;
                try {
                    binaryStream = resource.streamContent();
                }
                catch (IOException e) {
                    return null;
                }
                Permission permission = ALL_PERMISSION;
                synchronized (permission) {
                    int j;
                    long[] result2 = new long[this.lastModifiedDates.length + 1];
                    for (j = 0; j < this.lastModifiedDates.length; ++j) {
                        result2[j] = this.lastModifiedDates[j];
                    }
                    result2[this.lastModifiedDates.length] = entry.lastModified;
                    this.lastModifiedDates = result2;
                    String[] result = new String[this.paths.length + 1];
                    for (j = 0; j < this.paths.length; ++j) {
                        result[j] = this.paths[j];
                    }
                    result[this.paths.length] = fullPath;
                    this.paths = result;
                    continue;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        if (entry != null) {
            this.readEntryData(entry, name, binaryStream, contentLength, null);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceEntry findResourceInternalFromJars(String name, String path) {
        ResourceEntry entry = null;
        JarEntry jarEntry = null;
        int contentLength = -1;
        InputStream binaryStream = null;
        if (!this.openJARs()) {
            return null;
        }
        int jarFilesLength = this.jarFiles.length;
        for (int i = 0; entry == null && i < jarFilesLength; ++i) {
            jarEntry = this.jarFiles[i].getJarEntry(path);
            if (jarEntry == null) continue;
            entry = new ResourceEntry();
            try {
                entry.codeBase = this.getURL(this.jarRealFiles[i]);
                String jarFakeUrl = this.getURI(this.jarRealFiles[i]).toString();
                jarFakeUrl = "jar:" + jarFakeUrl + "!/" + path;
                entry.source = new URL(jarFakeUrl);
                entry.lastModified = this.jarRealFiles[i].lastModified();
            }
            catch (MalformedURLException e) {
                return null;
            }
            contentLength = (int)jarEntry.getSize();
            try {
                entry.manifest = this.jarFiles[i].getManifest();
                binaryStream = this.jarFiles[i].getInputStream(jarEntry);
            }
            catch (IOException e) {
                return null;
            }
            if (path.endsWith(".class")) continue;
            byte[] buf = new byte[1024];
            File resourceFile = new File(this.loaderDir, jarEntry.getName());
            if (resourceFile.exists()) continue;
            Enumeration<JarEntry> entries = this.jarFiles[i].entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry2 = entries.nextElement();
                if (jarEntry2.isDirectory() || jarEntry2.getName().endsWith(".class")) continue;
                resourceFile = new File(this.loaderDir, jarEntry2.getName());
                resourceFile.getParentFile().mkdirs();
                FileOutputStream os = null;
                InputStream is = null;
                try {
                    int n;
                    is = this.jarFiles[i].getInputStream(jarEntry2);
                    os = new FileOutputStream(resourceFile);
                    while ((n = is.read(buf)) > 0) {
                        os.write(buf, 0, n);
                    }
                }
                catch (IOException e) {}
                continue;
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (os == null) continue;
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (entry != null) {
            this.readEntryData(entry, name, binaryStream, contentLength, jarEntry);
        }
        return entry;
    }

    private void readEntryData(ResourceEntry entry, String name, InputStream binaryStream, int contentLength, JarEntry jarEntry) {
        if (binaryStream == null) {
            return;
        }
        byte[] binaryContent = new byte[contentLength];
        try {
            int n;
            int pos = 0;
            while ((n = binaryStream.read(binaryContent, pos, binaryContent.length - pos)) > 0) {
                pos += n;
            }
            binaryStream.close();
        }
        catch (Exception e) {
            String msg = rb.getString("webappClassLoader.readClassError");
            msg = MessageFormat.format(msg, name);
            logger.log(Level.WARNING, msg, e);
            return;
        }
        if (PreprocessorUtil.isPreprocessorEnabled()) {
            binaryContent = PreprocessorUtil.processClass((String)name, (byte[])binaryContent);
        }
        entry.binaryContent = binaryContent;
        if (jarEntry != null) {
            entry.certificates = jarEntry.getCertificates();
        }
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            WebappClassLoader webappClassLoader = this;
            synchronized (webappClassLoader) {
                return entry.loadedClass;
            }
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("java.")) {
            return true;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        if (this.overridablePackages != null) {
            for (String overridePkg : this.overridablePackages) {
                if (!packageName.startsWith(overridePkg)) continue;
                return false;
            }
        }
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!packageName.startsWith(packageTriggers[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        return !name.startsWith("java.");
    }

    protected URL getURL(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.escapePlus(realFile.toURI().toURL());
    }

    protected URL getURI(File file) throws MalformedURLException {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.escapePlus(file.toURI().toURL());
    }

    private URL escapePlus(URL url) {
        String path;
        URL result = url;
        if ("file".equals(url.getProtocol()) && (path = url.getPath()) != null && path.contains("+")) {
            try {
                result = new URL(url.getProtocol(), url.getHost(), url.getPort(), path.replace("+", "%2B"));
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return result;
    }

    protected static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                WebappClassLoader.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public void addByteCodePreprocessor(BytecodePreprocessor preprocessor) {
        this.byteCodePreprocessors.add(preprocessor);
    }

    private void purgeELBeanClasses() {
        Field[] fieldlist = BeanELResolver.class.getDeclaredFields();
        for (int i = 0; i < fieldlist.length; ++i) {
            Field fld = fieldlist[i];
            if (!fld.getName().equals("properties")) continue;
            this.purgeELBeanClasses(fld);
        }
    }

    private void purgeELBeanClasses(final Field fld) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    fld.setAccessible(true);
                    return null;
                }
            });
        } else {
            fld.setAccessible(true);
        }
        Map m = null;
        try {
            m = (Map)fld.get(null);
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.WARNING, "webappClassLoader.unablePurgeBeanClasses", iae);
            return;
        }
        if (m.size() == 0) {
            return;
        }
        Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            Class mbeanClass = (Class)iter.next();
            if (!this.equals(mbeanClass.getClassLoader())) continue;
            iter.remove();
        }
    }

    public ClassLoader copy() {
        logger.entering("WebModuleListener$InstrumentableWebappClassLoader", "copy");
        return new URLClassLoader(this.getURLs(), this.getParent());
    }

    public void addTransformer(final ClassFileTransformer transformer) {
        final WebappClassLoader cl = this;
        this.addByteCodePreprocessor(new BytecodePreprocessor(){

            public boolean initialize(Hashtable parameters) {
                return true;
            }

            public byte[] preprocess(String resourceName, byte[] classBytes) {
                try {
                    String classname = resourceName.substring(0, resourceName.length() - 6);
                    byte[] newBytes = transformer.transform(cl, classname, null, null, classBytes);
                    return newBytes == null ? classBytes : newBytes;
                }
                catch (IllegalClassFormatException e) {
                    logger.logp(Level.WARNING, "WebModuleListener$InstrumentableClassLoader$BytecodePreprocessor", "preprocess", e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private String getJavaVersion() {
        String version = null;
        SecurityManager sm = System.getSecurityManager();
        version = sm != null ? (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        }) : System.getProperty("java.version");
        return version;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        public Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PrivilegedFindResource
    implements PrivilegedAction<ResourceEntry> {
        private File file;
        private String path;

        PrivilegedFindResource(File file, String path) {
            this.file = file;
            this.path = path;
        }

        @Override
        public ResourceEntry run() {
            return WebappClassLoader.this.findResourceInternal(this.file, this.path);
        }
    }
}

