/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jspcaching.integration;

import com.sun.appserv.web.taglibs.cache.CacheTag;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.net.JarURIPattern;
import com.sun.logging.LogDomains;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.web.TldProvider;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jspCachingTld")
@Scoped(value=Singleton.class)
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    private static final Logger logger = LogDomains.getLogger(GlassFishTldProvider.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    ServerContext serverContext;
    @Inject
    ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();

    public String getName() {
        return "jspCachingTld";
    }

    public Map<URI, List<String>> getTldMap() {
        return this.tldMap == null ? null : (Map)((HashMap)this.tldMap).clone();
    }

    public Map<URI, List<String>> getTldListenerMap() {
        return this.getTldMap();
    }

    public void postConstruct() {
        Config cfg = (Config)this.serverContext.getDefaultHabitat().getComponent(Config.class);
        WebContainer webContainer = cfg.getWebContainer();
        if (webContainer == null) {
            return;
        }
        if (!Boolean.valueOf(webContainer.getJspCachingEnabled()).booleanValue()) {
            return;
        }
        Class<CacheTag> jspCachingImplClass = CacheTag.class;
        URI[] uris = null;
        Module m = null;
        if (jspCachingImplClass != null) {
            m = this.registry.find(jspCachingImplClass);
        }
        if (m != null) {
            uris = m.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                if (urls != null && urls.length > 0) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = urls[i].toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            String msg = rb.getString("tldProvider.ignoreUrl");
                            msg = MessageFormat.format(msg, urls[i]);
                            logger.log(Level.WARNING, msg, e);
                        }
                    }
                }
            } else {
                logger.log(Level.WARNING, "taglibs.unableToDetermineTldResources", new Object[]{"JSP Caching", classLoader, GlassFishTldProvider.class.getName()});
            }
        }
        if (uris != null && uris.length > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List entries = JarURIPattern.getJarEntries((URI)uri, (Pattern)pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

