/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolFinder;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-network-listener")
@Scoped(value=PerLookup.class)
@I18n(value="create.network.listener")
public class CreateNetworkListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateNetworkListener.class);
    @Param(name="address", optional=true)
    String address;
    @Param(name="listenerport", optional=false)
    String port;
    @Param(name="threadpool", optional=true, defaultValue="http-thread-pool")
    String threadPool;
    @Param(name="protocol", optional=false)
    String protocol;
    @Param(name="name", primary=true)
    String listenerName;
    @Param(name="transport", optional=true, defaultValue="tcp")
    String transport;
    @Param(name="enabled", optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="jkenabled", optional=true, defaultValue="false")
    Boolean jkEnabled;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        NetworkListeners nls = networkConfig.getNetworkListeners();
        for (NetworkListener networkListener : nls.getNetworkListener()) {
            if (!networkListener.getName().equals(this.listenerName)) continue;
            report.setMessage(localStrings.getLocalString("create.network.listener.fail.duplicate", "Network Listener named {0} already exists.", new Object[]{this.listenerName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.verifyUniquePort(networkConfig)) {
            report.setMessage(localStrings.getLocalString("port.in.use", "Port [{0}] is already taken for address [{1}], please choose another port.", new Object[]{this.port, this.address}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol prot = (Protocol)this.habitat.getComponent(Protocol.class, this.protocol);
        if (prot == null) {
            report.setMessage(localStrings.getLocalString("create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", new Object[]{this.protocol}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (prot.getHttp() == null && prot.getPortUnification() == null) {
            report.setMessage(localStrings.getLocalString("create.network.listener.fail.bad.protocol", "Protocol {0} has neither a protocol nor a port-unification configured", new Object[]{this.protocol}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws TransactionFailure, PropertyVetoException {
                    NetworkListeners listeners = (NetworkListeners)params[0];
                    NetworkListener newNetworkListener = (NetworkListener)listeners.createChild(NetworkListener.class);
                    newNetworkListener.setProtocol(CreateNetworkListener.this.protocol);
                    newNetworkListener.setTransport(CreateNetworkListener.this.transport);
                    newNetworkListener.setEnabled(CreateNetworkListener.this.enabled.toString());
                    newNetworkListener.setJkEnabled(CreateNetworkListener.this.jkEnabled.toString());
                    newNetworkListener.setPort(CreateNetworkListener.this.port);
                    newNetworkListener.setThreadPool(CreateNetworkListener.this.threadPool);
                    newNetworkListener.setName(CreateNetworkListener.this.listenerName);
                    newNetworkListener.setAddress(CreateNetworkListener.this.address);
                    listeners.getNetworkListener().add(newNetworkListener);
                    ((VirtualServer)params[1]).addNetworkListener(CreateNetworkListener.this.listenerName);
                    return newNetworkListener;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{nls, this.findVirtualServer(prot)});
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.network.listener.fail", "{0} create failed: " + (e.getMessage() == null ? "No reason given" : e.getMessage()), new Object[]{this.listenerName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private VirtualServer findVirtualServer(Protocol protocol) {
        String name = null;
        Http http = protocol.getHttp();
        if (http != null) {
            name = http.getDefaultVirtualServer();
        } else {
            List finders = protocol.getPortUnification().getProtocolFinder();
            for (ProtocolFinder finder : finders) {
                Protocol p;
                if (name != null || (p = finder.findProtocol()).getHttp() == null) continue;
                name = p.getHttp().getDefaultVirtualServer();
            }
        }
        return (VirtualServer)this.habitat.getComponent(VirtualServer.class, name);
    }

    private boolean verifyUniquePort(NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.port) || !listener.getAddress().trim().equals(this.address)) continue;
            return false;
        }
        return true;
    }
}

