/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.PortUnification;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.web.admin.cli.CreateProtocol;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-port-unification")
@Scoped(value=PerLookup.class)
@I18n(value="create.port.unification")
public class CreatePortUnification
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreatePortUnification.class);
    @Param(name="name", primary=true)
    String name;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.habitat.getComponent(Protocol.class, this.name) != null) {
            report.setMessage(localStrings.getLocalString("create.portunif.protocol.duplicate", "A protocol definition named {0} already exists.", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            CreateProtocol.create((Protocols)this.habitat.getComponent(Protocols.class), this.name, false);
            Protocol protocol = (Protocol)this.habitat.getComponent(Protocol.class, this.name);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws PropertyVetoException, TransactionFailure {
                    PortUnification portUnification = (PortUnification)param.createChild(PortUnification.class);
                    param.setPortUnification(portUnification);
                    return null;
                }
            }, (ConfigBeanProxy)protocol);
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("create.portunif.fail", "{0} create failed: " + (e.getMessage() == null ? "No reason given" : e.getMessage()), new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
    }
}

