/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Ports;
import org.glassfish.api.embedded.web.ConfigException;
import org.glassfish.api.embedded.web.Context;
import org.glassfish.api.embedded.web.EmbeddedWebContainer;
import org.glassfish.api.embedded.web.VirtualServer;
import org.glassfish.api.embedded.web.WebBuilder;
import org.glassfish.api.embedded.web.WebListener;
import org.glassfish.web.embed.impl.ContextImpl;
import org.glassfish.web.embed.impl.VirtualServerImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EmbeddedWebContainerImpl
implements EmbeddedWebContainer {
    @Inject
    Habitat habitat;
    private static Logger log = Logger.getLogger(EmbeddedWebContainerImpl.class.getName());
    Inhabitant<? extends Container> webContainer;
    private VirtualServer defaultVirtualServer = null;
    Inhabitant<?> embeddedInhabitant;
    private Embedded embedded = null;
    private Engine engine = null;
    private File path = null;
    private String defaultDomain = "com.sun.appserv";
    private boolean listings;

    @Override
    public void setConfiguration(WebBuilder builder) {
        this.setPath(builder.getDocRootDir());
        this.listings = builder.getListings();
    }

    public List<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "web"));
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "weld"));
        Sniffer security = (Sniffer)this.habitat.getComponent(Sniffer.class, "Security");
        if (security != null) {
            sniffers.add(security);
        }
        return sniffers;
    }

    public void bind(Port port, String protocol) {
    }

    @Override
    public void start() throws org.glassfish.api.embedded.LifecycleException {
        if (log.isLoggable(Level.INFO)) {
            log.info("EmbeddedWebContainer is starting");
        }
        this.webContainer = this.habitat.getInhabitant(Container.class, "com.sun.enterprise.web.WebContainer");
        if (this.webContainer == null) {
            log.severe("Cannot find webcontainer implementation");
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)new Exception("Cannot find web container implementation"));
        }
        this.embeddedInhabitant = this.habitat.getInhabitantByType("com.sun.enterprise.web.EmbeddedWebContainer");
        if (this.embeddedInhabitant == null) {
            log.severe("Cannot find embedded implementation");
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)new Exception("Cannot find embedded implementation"));
        }
        try {
            this.webContainer.get();
            this.embedded = (Embedded)this.embeddedInhabitant.get();
            Engine[] engines = this.embedded.getEngines();
            if (engines == null) {
                throw new org.glassfish.api.embedded.LifecycleException((Throwable)new Exception("Cannot find engine implementation"));
            }
            this.engine = engines[0];
            int port = 8080;
            String webListenerId = "http-listener-1";
            String virtualServerId = "server";
            String hostName = "localhost";
            File docRoot = this.getPath();
            VirtualServer vs = this.findVirtualServer(virtualServerId);
            if (vs != null) {
                this.defaultVirtualServer = vs;
            } else {
                this.defaultVirtualServer = this.createVirtualServer(virtualServerId, docRoot);
                this.addVirtualServer(this.defaultVirtualServer);
            }
            if (this.listings) {
                for (Context context : this.defaultVirtualServer.getContexts()) {
                    context.setDirectoryListing(this.listings);
                }
            }
        }
        catch (Exception e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public void stop() throws org.glassfish.api.embedded.LifecycleException {
        if (this.webContainer != null && this.webContainer.isInstantiated()) {
            try {
                this.webContainer.release();
            }
            catch (Exception e) {
                throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
            }
        }
        if (this.webContainer != null && this.webContainer.isInstantiated()) {
            try {
                this.webContainer.release();
            }
            catch (Exception e) {
                throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
            }
        }
    }

    @Override
    public Context createContext(File docRoot, String contextRoot, ClassLoader classLoader) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating context '" + contextRoot + "' with docBase '" + docRoot.getPath() + "'");
        }
        ContextImpl context = new ContextImpl();
        context.setDocBase(docRoot.getPath());
        context.setPath(contextRoot);
        context.setDirectoryListing(this.listings);
        if (classLoader != null) {
            context.setParentClassLoader(classLoader);
        } else {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        Realm realm = (Realm)this.habitat.getByContract(Realm.class);
        context.setRealm(realm);
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener(config);
        try {
            if (this.defaultVirtualServer != null) {
                this.defaultVirtualServer.addContext(context, contextRoot);
            }
        }
        catch (Exception ex) {
            log.severe("Couldn't add context " + contextRoot + " to default virtual server");
        }
        return context;
    }

    @Override
    public Context createContext(File docRoot, ClassLoader classLoader) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating context with docBase '" + docRoot.getPath() + "'");
        }
        ContextImpl context = new ContextImpl();
        context.setDocBase(docRoot.getAbsolutePath());
        context.setDirectoryListing(this.listings);
        if (classLoader != null) {
            context.setParentClassLoader(classLoader);
        } else {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        Realm realm = (Realm)this.habitat.getByContract(Realm.class);
        context.setRealm(realm);
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener(config);
        return context;
    }

    @Override
    public <T extends WebListener> T createWebListener(String id, Class<T> c) throws InstantiationException, IllegalAccessException {
        WebListener webListener = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating connector " + id);
        }
        try {
            webListener = (WebListener)c.newInstance();
            webListener.setId(id);
        }
        catch (Exception e) {
            log.severe("Couldn't create connector");
        }
        return (T)webListener;
    }

    @Override
    public void addWebListener(WebListener webListener) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        if (this.findWebListener(webListener.getId()) != null) {
            throw new ConfigException("Connector with name '" + webListener.getId() + "' already exsits");
        }
        this.embedded.addConnector((Connector)((Object)webListener));
        if (log.isLoggable(Level.INFO)) {
            log.info("Added connector " + webListener.getId());
        }
    }

    @Override
    public WebListener findWebListener(String id) {
        WebListener webListener = null;
        for (Connector connector : this.embedded.findConnectors()) {
            if (!connector.getName().equals(id)) continue;
            webListener = (WebListener)((Object)connector);
        }
        return webListener;
    }

    @Override
    public Collection<WebListener> getWebListeners() {
        WebListener[] connectors = (WebListener[])this.embedded.findConnectors();
        return Arrays.asList(connectors);
    }

    @Override
    public void removeWebListener(WebListener webListener) throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.embedded.removeConnector((Connector)((Object)webListener));
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public VirtualServer createVirtualServer(String id, File docRoot, WebListener ... webListeners) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Created virtual server " + id + " with ports ");
        }
        VirtualServerImpl virtualServer = new VirtualServerImpl();
        virtualServer.setName(id);
        if (docRoot != null) {
            virtualServer.setAppBase(docRoot.getPath());
        }
        String[] names = new String[webListeners.length];
        for (int i = 0; i < webListeners.length; ++i) {
            names[i] = webListeners[i].getId();
            if (!log.isLoggable(Level.INFO)) continue;
            log.info("" + names[i]);
        }
        virtualServer.setNetworkListenerNames(names);
        return virtualServer;
    }

    @Override
    public VirtualServer createVirtualServer(String id, File docRoot) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Created virtual server " + id);
        }
        VirtualServerImpl virtualServer = new VirtualServerImpl();
        virtualServer.setName(id);
        if (docRoot != null) {
            virtualServer.setAppBase(docRoot.getPath());
        }
        Ports ports = (Ports)this.habitat.getComponent(Ports.class);
        String[] portsArray = null;
        if (ports != null) {
            Collection coll = ports.getPorts();
            portsArray = new String[coll.size()];
            int i = 0;
            for (Port port : coll) {
                portsArray[i] = Integer.toString(port.getPortNumber());
                if (log.isLoggable(Level.INFO)) {
                    log.info("port = " + portsArray[i]);
                }
                ++i;
            }
            virtualServer.setNetworkListenerNames(portsArray);
        }
        return virtualServer;
    }

    @Override
    public void addVirtualServer(VirtualServer virtualServer) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        if (this.findVirtualServer(virtualServer.getID()) != null) {
            throw new ConfigException("VirtualServer with id " + virtualServer.getID() + " is already registered");
        }
        this.engine.setDefaultHost(virtualServer.getID());
        this.engine.addChild((org.apache.catalina.Container)((Object)virtualServer));
        if (log.isLoggable(Level.INFO)) {
            log.info("Added virtual server " + virtualServer.getID());
        }
    }

    @Override
    public VirtualServer findVirtualServer(String id) {
        return (VirtualServer)((Object)this.engine.findChild(id));
    }

    @Override
    public Collection<VirtualServer> getVirtualServers() {
        ArrayList<VirtualServer> virtualServers = new ArrayList<VirtualServer>();
        for (org.apache.catalina.Container child : this.engine.findChildren()) {
            if (!(child instanceof VirtualServer)) continue;
            virtualServers.add((VirtualServer)((Object)child));
        }
        return virtualServers;
    }

    @Override
    public void removeVirtualServer(VirtualServer virtualServer) throws org.glassfish.api.embedded.LifecycleException {
        this.engine.removeChild((org.apache.catalina.Container)((Object)virtualServer));
    }

    public void setPath(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    @Override
    public void setLogLevel(Level level) {
        log.setLevel(level);
    }
}

