/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolChain;
import com.sun.grizzly.config.dom.ProtocolChainInstanceHandler;
import com.sun.grizzly.config.dom.ProtocolFilter;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-protocol-filter")
@Scoped(value=PerLookup.class)
@I18n(value="delete.protocol.filter")
public class DeleteProtocolFilter
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteProtocolFilter.class);
    @Param(name="name", primary=true)
    String name;
    @Param(name="protocol", optional=false)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    private ActionReport report;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        this.report = context.getActionReport();
        try {
            Protocols protocols = this.config.getNetworkConfig().getProtocols();
            Protocol protocol = protocols.findProtocol(this.protocolName);
            this.validate((ConfigBeanProxy)protocol, "create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", this.protocolName);
            ProtocolChainInstanceHandler handler = this.getHandler(protocol);
            ProtocolChain chain = this.getChain(handler);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ProtocolChain>(){

                public Object run(ProtocolChain param) throws PropertyVetoException, TransactionFailure {
                    List list = param.getProtocolFilter();
                    ArrayList<ProtocolFilter> newList = new ArrayList<ProtocolFilter>();
                    for (ProtocolFilter filter : list) {
                        if (DeleteProtocolFilter.this.name.equals(filter.getName())) continue;
                        newList.add(filter);
                    }
                    if (list.size() == newList.size()) {
                        throw new RuntimeException(String.format("No filter named %s found for protocol %s", DeleteProtocolFilter.this.name, DeleteProtocolFilter.this.protocolName));
                    }
                    param.setProtocolFilter(newList);
                    return null;
                }
            }, (ConfigBeanProxy)chain);
            this.cleanChain(chain);
            this.cleanHandler(handler);
        }
        catch (ValidationFailureException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.setMessage(localStrings.getLocalString("delete.fail", "{0} delete failed: {1}", new Object[]{this.name, e.getMessage() == null ? "No reason given" : e.getMessage()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
            return;
        }
    }

    private ProtocolChain getChain(ProtocolChainInstanceHandler handler) throws TransactionFailure {
        ProtocolChain chain = handler.getProtocolChain();
        if (chain == null) {
            this.report.setMessage(localStrings.getLocalString("not.found", "No {0} element found for {1}", new Object[]{"protocol-chain", ((Protocol)handler.getParent(Protocol.class)).getName()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return chain;
    }

    private void cleanChain(ProtocolChain chain) throws TransactionFailure {
        if (chain != null && chain.getProtocolFilter().isEmpty()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ProtocolChainInstanceHandler>(){

                public Object run(ProtocolChainInstanceHandler param) throws PropertyVetoException, TransactionFailure {
                    param.setProtocolChain(null);
                    return null;
                }
            }, (ConfigBeanProxy)chain.getParent(ProtocolChainInstanceHandler.class));
        }
    }

    private ProtocolChainInstanceHandler getHandler(Protocol protocol) throws TransactionFailure {
        ProtocolChainInstanceHandler handler = protocol.getProtocolChainInstanceHandler();
        if (handler == null) {
            this.report.setMessage(localStrings.getLocalString("not.found", "No {0} element found for {1}", new Object[]{"protocol-chain-instance-handler", protocol.getName()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return handler;
    }

    private void cleanHandler(ProtocolChainInstanceHandler handler) throws TransactionFailure {
        if (handler != null && handler.getProtocolChain() == null) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws PropertyVetoException, TransactionFailure {
                    param.setProtocolChainInstanceHandler(null);
                    return null;
                }
            }, (ConfigBeanProxy)handler.getParent(Protocol.class));
        }
    }

    private void validate(ConfigBeanProxy check, String key, String defaultFormat, String ... arguments) throws ValidationFailureException {
        if (check == null) {
            this.report.setMessage(localStrings.getLocalString(key, defaultFormat, (Object[])arguments));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new ValidationFailureException();
        }
    }

    private class ValidationFailureException
    extends Exception {
        private ValidationFailureException() {
        }
    }
}

