/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolChain;
import com.sun.grizzly.config.dom.ProtocolFilter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-protocol-filters")
@Scoped(value=PerLookup.class)
@I18n(value="list.protocol.filters")
public class ListProtocolFilters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListProtocolFilters.class);
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="protocol", primary=true)
    String protocolName;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        ActionReport report = context.getActionReport();
        Protocol protocol = this.config.getNetworkConfig().getProtocols().findProtocol(this.protocolName);
        ProtocolChain chain = protocol.getProtocolChainInstanceHandler().getProtocolChain();
        for (ProtocolFilter filter : chain.getProtocolFilter()) {
            report.getTopMessagePart().addChild().setMessage(filter.getName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

