/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Engine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Embedded;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Ports;
import org.glassfish.api.embedded.ScatteredArchive;
import org.glassfish.api.embedded.web.ConfigException;
import org.glassfish.api.embedded.web.Context;
import org.glassfish.api.embedded.web.EmbeddedWebContainer;
import org.glassfish.api.embedded.web.VirtualServer;
import org.glassfish.api.embedded.web.WebBuilder;
import org.glassfish.api.embedded.web.WebListener;
import org.glassfish.web.embed.impl.VirtualServerImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EmbeddedWebContainerImpl
implements EmbeddedWebContainer {
    @Inject
    NetworkConfig config;
    @Inject
    Habitat habitat;
    @Inject
    HttpService httpService;
    private static Logger log = Logger.getLogger(EmbeddedWebContainerImpl.class.getName());
    Inhabitant<? extends Container> webContainer;
    private VirtualServer defaultVirtualServer = null;
    Inhabitant<?> embeddedInhabitant;
    private Embedded embedded = null;
    private Engine engine = null;
    private File path = null;
    private boolean listings;
    private String defaultvs = "server";
    private int portNumber;
    private String listenerName = "embedded-listener";
    private String securityEnabled = "false";
    private List<WebListener> listeners = new ArrayList<WebListener>();

    @Override
    public void setConfiguration(WebBuilder builder) {
        this.setPath(builder.getDocRootDir());
        this.listings = builder.getListings();
    }

    public List<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "web"));
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "weld"));
        Sniffer security = (Sniffer)this.habitat.getComponent(Sniffer.class, "Security");
        if (security != null) {
            sniffers.add(security);
        }
        return sniffers;
    }

    public void bind(Port port, String protocol) {
        log.info("EmbeddedWebContainer binding port " + port.getPortNumber() + " protocol " + protocol);
        this.portNumber = port.getPortNumber();
        this.listenerName = this.getListenerName();
        WebListener webListener = new WebListener();
        webListener.setId(this.listenerName);
        webListener.setPort(this.portNumber);
        this.listeners.add(webListener);
        if (protocol.equals("http")) {
            this.securityEnabled = "false";
        }
        if (protocol.equals("https")) {
            this.securityEnabled = "true";
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    protocol.setName(EmbeddedWebContainerImpl.this.listenerName);
                    protocol.setSecurityEnabled(EmbeddedWebContainerImpl.this.securityEnabled);
                    param.getProtocol().add(protocol);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setDefaultVirtualServer(EmbeddedWebContainerImpl.this.defaultvs);
                    protocol.setHttp(http);
                    return protocol;
                }
            }, (ConfigBeanProxy)this.config.getProtocols());
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws TransactionFailure {
                    NetworkListeners nls = (NetworkListeners)params[0];
                    Transports transports = (Transports)params[1];
                    NetworkListener listener = (NetworkListener)nls.createChild(NetworkListener.class);
                    listener.setName(EmbeddedWebContainerImpl.this.listenerName);
                    listener.setPort(Integer.toString(EmbeddedWebContainerImpl.this.portNumber));
                    listener.setProtocol(EmbeddedWebContainerImpl.this.listenerName);
                    listener.setThreadPool("http-thread-pool");
                    if (listener.findThreadPool() == null) {
                        ThreadPool pool = (ThreadPool)nls.createChild(ThreadPool.class);
                        pool.setName(EmbeddedWebContainerImpl.this.listenerName);
                        listener.setThreadPool(EmbeddedWebContainerImpl.this.listenerName);
                    }
                    listener.setTransport("tcp");
                    if (listener.findTransport() == null) {
                        Transport transport = (Transport)transports.createChild(Transport.class);
                        transport.setName(EmbeddedWebContainerImpl.this.listenerName);
                        listener.setTransport(EmbeddedWebContainerImpl.this.listenerName);
                    }
                    nls.getNetworkListener().add(listener);
                    return listener;
                }
            }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.config.getNetworkListeners(), this.config.getTransports()});
            com.sun.enterprise.config.serverbeans.VirtualServer vs = this.httpService.getVirtualServerByName(this.defaultvs);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<com.sun.enterprise.config.serverbeans.VirtualServer>(){

                public Object run(com.sun.enterprise.config.serverbeans.VirtualServer avs) throws PropertyVetoException {
                    avs.addNetworkListener(EmbeddedWebContainerImpl.this.listenerName);
                    return avs;
                }
            }, (ConfigBeanProxy)vs);
        }
        catch (Exception e) {
            this.removeListener(this.listenerName);
            e.printStackTrace();
        }
    }

    private String getListenerName() {
        int i = 1;
        if (!this.existsListener(this.listenerName)) {
            return this.listenerName;
        }
        String name = "embedded-listener";
        while (this.existsListener(name)) {
            name = "embedded-listener-" + i++;
        }
        return name;
    }

    private boolean existsListener(String lName) {
        for (NetworkListener nl : this.config.getNetworkListeners().getNetworkListener()) {
            if (!nl.getName().equals(lName)) continue;
            return true;
        }
        return false;
    }

    private void removeListener(String name) {
        String listenerName = name;
        try {
            NetworkListeners networkListeners = this.config.getNetworkListeners();
            final NetworkListener listenerToBeRemoved = this.config.getNetworkListener(listenerName);
            if (listenerToBeRemoved == null) {
                log.severe("Network Listener " + listenerName + " doesn't exist");
            } else {
                com.sun.enterprise.config.serverbeans.VirtualServer virtualServer = this.httpService.getVirtualServerByName(listenerToBeRemoved.findHttpProtocol().getHttp().getDefaultVirtualServer());
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... params) throws PropertyVetoException {
                        NetworkListeners listeners = (NetworkListeners)params[0];
                        com.sun.enterprise.config.serverbeans.VirtualServer server = (com.sun.enterprise.config.serverbeans.VirtualServer)params[1];
                        listeners.getNetworkListener().remove(listenerToBeRemoved);
                        server.removeNetworkListener(listenerToBeRemoved.getName());
                        return listenerToBeRemoved;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{networkListeners, virtualServer});
            }
        }
        catch (TransactionFailure transactionFailure) {
            // empty catch block
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (log.isLoggable(Level.INFO)) {
            log.info("EmbeddedWebContainer is starting");
        }
        this.webContainer = this.habitat.getInhabitant(Container.class, "com.sun.enterprise.web.WebContainer");
        if (this.webContainer == null) {
            log.severe("Cannot find webcontainer implementation");
            throw new LifecycleException((Throwable)new Exception("Cannot find web container implementation"));
        }
        this.embeddedInhabitant = this.habitat.getInhabitantByType("com.sun.enterprise.web.EmbeddedWebContainer");
        if (this.embeddedInhabitant == null) {
            log.severe("Cannot find embedded implementation");
            throw new LifecycleException((Throwable)new Exception("Cannot find embedded implementation"));
        }
        try {
            this.webContainer.get();
            this.embedded = (Embedded)this.embeddedInhabitant.get();
            Engine[] engines = this.embedded.getEngines();
            if (engines == null) {
                throw new LifecycleException((Throwable)new Exception("Cannot find engine implementation"));
            }
            this.engine = engines[0];
            File docRoot = this.getPath();
            VirtualServer vs = this.findVirtualServer(this.defaultvs);
            if (vs != null) {
                this.defaultVirtualServer = vs;
            } else {
                this.defaultVirtualServer = this.createVirtualServer(this.defaultvs, docRoot);
                this.addVirtualServer(this.defaultVirtualServer);
            }
            if (this.listings) {
                for (Context context : this.defaultVirtualServer.getContexts()) {
                    context.setDirectoryListing(this.listings);
                }
            }
            if (this.config.getNetworkListeners().getNetworkListener().isEmpty()) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Listener does not exist - creating a new listener at port 8080");
                }
                WebListener listener = this.createWebListener(this.listenerName, WebListener.class);
                listener.setPort(8080);
                this.addWebListener(listener);
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (this.webContainer != null && this.webContainer.isInstantiated()) {
            try {
                this.webContainer.release();
            }
            catch (Exception e) {
                throw new LifecycleException((Throwable)e);
            }
        }
        if (this.webContainer != null && this.webContainer.isInstantiated()) {
            try {
                this.webContainer.release();
            }
            catch (Exception e) {
                throw new LifecycleException((Throwable)e);
            }
        }
    }

    @Override
    public Context createContext(File docRoot, String contextRoot, ClassLoader classLoader) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating context '" + contextRoot + "' with docBase '" + docRoot.getPath() + "'");
        }
        String appName = null;
        Context context = null;
        try {
            EmbeddedDeployer deployer = (EmbeddedDeployer)this.habitat.getByContract(EmbeddedDeployer.class);
            ScatteredArchive.Builder builder = new ScatteredArchive.Builder(contextRoot, docRoot);
            builder.resources(docRoot);
            builder.addClassPath(docRoot.toURL());
            DeployCommandParameters dp = new DeployCommandParameters(docRoot);
            appName = deployer.deploy((ReadableArchive)builder.buildWar(), dp);
            if (!appName.startsWith("/")) {
                appName = "/" + appName;
            }
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
        }
        for (org.apache.catalina.Container vs : this.engine.findChildren()) {
            context = ((VirtualServer)((Object)vs)).findContext(appName);
        }
        return context;
    }

    @Override
    public Context createContext(File docRoot, ClassLoader classLoader) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating context with docBase '" + docRoot.getPath() + "'");
        }
        String appName = null;
        Context context = null;
        try {
            EmbeddedDeployer deployer = (EmbeddedDeployer)this.habitat.getByContract(EmbeddedDeployer.class);
            ScatteredArchive.Builder builder = new ScatteredArchive.Builder("", docRoot);
            builder.resources(docRoot);
            builder.addClassPath(docRoot.toURL());
            DeployCommandParameters dp = new DeployCommandParameters(docRoot);
            appName = deployer.deploy((ReadableArchive)builder.buildWar(), dp);
            if (!appName.startsWith("/")) {
                appName = "/" + appName;
            }
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
        }
        for (org.apache.catalina.Container vs : this.engine.findChildren()) {
            context = ((VirtualServer)((Object)vs)).findContext(appName);
        }
        return context;
    }

    @Override
    public <T extends WebListener> T createWebListener(String id, Class<T> c) throws InstantiationException, IllegalAccessException {
        WebListener webListener = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Creating connector " + id);
        }
        try {
            webListener = (WebListener)c.newInstance();
            webListener.setId(id);
        }
        catch (Exception e) {
            log.severe("Couldn't create connector " + e.getMessage());
        }
        return (T)webListener;
    }

    @Override
    public void addWebListener(WebListener webListener) throws ConfigException, LifecycleException {
        if (this.findWebListener(webListener.getId()) != null) {
            throw new ConfigException("Connector with name '" + webListener.getId() + "' already exsits");
        }
        this.listenerName = webListener.getId();
        if (log.isLoggable(Level.INFO)) {
            log.info("Added connector " + webListener.getId());
        }
        this.listenerName = webListener.getId();
        try {
            Ports ports = (Ports)this.habitat.getComponent(Ports.class);
            Port port = ports.createPort(webListener.getPort());
            this.bind(port, "http");
        }
        catch (IOException ex) {
            throw new ConfigException(ex);
        }
    }

    @Override
    public WebListener findWebListener(String id) {
        for (WebListener listener : this.listeners) {
            if (!listener.getId().equals(id)) continue;
            return listener;
        }
        return null;
    }

    @Override
    public Collection<WebListener> getWebListeners() {
        return this.listeners;
    }

    @Override
    public void removeWebListener(WebListener webListener) throws LifecycleException {
        if (!this.listeners.contains(webListener)) {
            throw new LifecycleException((Throwable)new ConfigException("Connector with name '" + webListener.getId() + "' does not exsits"));
        }
        this.listeners.remove(webListener);
        this.removeListener(webListener.getId());
    }

    @Override
    public VirtualServer createVirtualServer(String id, File docRoot, WebListener ... webListeners) {
        VirtualServerImpl virtualServer = new VirtualServerImpl();
        virtualServer.setName(id);
        if (docRoot != null) {
            virtualServer.setAppBase(docRoot.getPath());
        }
        String[] names = new String[webListeners.length];
        for (int i = 0; i < webListeners.length; ++i) {
            names[i] = webListeners[i].getId();
        }
        virtualServer.setNetworkListenerNames(names);
        if (log.isLoggable(Level.INFO)) {
            log.info("Created virtual server " + id + " docroot " + docRoot.getPath() + " networklisteners " + virtualServer.getNetworkListeners());
        }
        try {
            for (WebListener listener : webListeners) {
                this.addWebListener(listener);
            }
        }
        catch (Exception ex) {
            log.severe("Couldn't add web listener for virtual server " + id);
        }
        return virtualServer;
    }

    @Override
    public VirtualServer createVirtualServer(String id, File docRoot) {
        VirtualServerImpl virtualServer = new VirtualServerImpl();
        virtualServer.setName(id);
        if (docRoot != null) {
            virtualServer.setAppBase(docRoot.getPath());
        }
        ArrayList<String> networkListenerNames = new ArrayList<String>();
        for (NetworkListener networkListener : this.config.getNetworkListeners().getNetworkListener()) {
            networkListenerNames.add(networkListener.getName());
        }
        virtualServer.setNetworkListenerNames(networkListenerNames.toArray(new String[0]));
        if (log.isLoggable(Level.INFO)) {
            log.info("Created virtual server " + id + " docroot " + docRoot.getPath() + " networklisteners " + virtualServer.getNetworkListeners());
        }
        return virtualServer;
    }

    @Override
    public void addVirtualServer(VirtualServer virtualServer) throws ConfigException, LifecycleException {
        final String virtualServerId = virtualServer.getID();
        final String networkListeners = ((StandardHost)((Object)virtualServer)).getNetworkListeners();
        final String docRoot = virtualServer.getDocRoot().getPath();
        for (com.sun.enterprise.config.serverbeans.VirtualServer vs : this.httpService.getVirtualServer()) {
            if (!virtualServerId.equals(vs.getId())) continue;
            throw new ConfigException("VirtualServer with id " + virtualServerId + " is already registered");
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    com.sun.enterprise.config.serverbeans.VirtualServer newVirtualServer = (com.sun.enterprise.config.serverbeans.VirtualServer)param.createChild(com.sun.enterprise.config.serverbeans.VirtualServer.class);
                    newVirtualServer.setId(virtualServerId);
                    newVirtualServer.setNetworkListeners(networkListeners);
                    Property property = (Property)newVirtualServer.createChild(Property.class);
                    property.setName("docroot");
                    property.setValue(docRoot);
                    newVirtualServer.getProperty().add(property);
                    param.getVirtualServer().add(newVirtualServer);
                    return newVirtualServer;
                }
            }, (ConfigBeanProxy)this.httpService);
        }
        catch (TransactionFailure e) {
            throw new LifecycleException((Throwable)e);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Added virtual server " + virtualServer.getID() + " with networklisteners " + networkListeners);
        }
    }

    @Override
    public VirtualServer findVirtualServer(String id) {
        return (VirtualServer)((Object)this.engine.findChild(id));
    }

    @Override
    public Collection<VirtualServer> getVirtualServers() {
        ArrayList<VirtualServer> virtualServers = new ArrayList<VirtualServer>();
        for (org.apache.catalina.Container child : this.engine.findChildren()) {
            if (!(child instanceof VirtualServer)) continue;
            virtualServers.add((VirtualServer)((Object)child));
        }
        return virtualServers;
    }

    @Override
    public void removeVirtualServer(VirtualServer virtualServer) throws LifecycleException {
        this.engine.removeChild((org.apache.catalina.Container)((Object)virtualServer));
    }

    public void setPath(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    @Override
    public void setLogLevel(Level level) {
        log.setLevel(level);
    }
}

