/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ResponseUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;

final class StandardHostValve
extends ValveBase {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(StandardHostValve.class.getName());
    private static final ClassLoader standardHostValveClassLoader = StandardHostValve.class.getClassLoader();
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private GlassFishValve errorReportValve;

    StandardHostValve() {
    }

    public String getInfo() {
        return info;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Context context = this.preInvoke(request, response);
        if (context == null) {
            return 2;
        }
        if (context.getPipeline().hasNonBasicValves() || context.hasCustomPipeline()) {
            context.getPipeline().invoke(request, response);
        } else {
            context.getPipeline().getBasic().invoke(request, response);
        }
        return 2;
    }

    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        Context context = this.preInvoke(request, response);
        if (context == null) {
            return;
        }
        if (context.getPipeline().hasNonBasicValves() || context.hasCustomPipeline()) {
            context.getPipeline().invoke(request, response);
        } else {
            context.getPipeline().getBasic().invoke(request, response);
        }
        this.postInvoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        try {
            String initParam;
            if (((ServletResponse)response).isCommitted()) {
                Object var9_3 = null;
                Thread.currentThread().setContextClassLoader(standardHostValveClassLoader);
                return;
            }
            HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
            response.setSuspended(false);
            Throwable t = (Throwable)hreq.getAttribute("javax.servlet.error.exception");
            if (t != null) {
                this.throwable(request, response, t);
            } else {
                this.status(request, response);
            }
            boolean isDefaultErrorPageEnabled = true;
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null && (initParam = wrapper.findInitParameter("org.glassfish.web.isDefaultErrorPageEnabled")) != null) {
                isDefaultErrorPageEnabled = Boolean.parseBoolean(initParam);
            }
            if (this.errorReportValve != null && response.isError() && isDefaultErrorPageEnabled) {
                this.errorReportValve.postInvoke(request, response);
            }
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            Thread.currentThread().setContextClassLoader(standardHostValveClassLoader);
            throw throwable;
        }
        Object var9_4 = null;
        Thread.currentThread().setContextClassLoader(standardHostValveClassLoader);
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(sm.getString("standardHost.clientAbort", realError.getCause().getMessage()));
            }
            return;
        }
        ErrorPage errorPage = StandardHostValve.findErrorPage(context, throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = StandardHostValve.findErrorPage(context, realError);
        }
        if (errorPage != null) {
            this.dispatchToErrorPage(request, response, errorPage, throwable, realError, 0);
        } else if (context.getDefaultErrorPage() != null) {
            this.dispatchToErrorPage(request, response, context.getDefaultErrorPage(), throwable, realError, 0);
        } else {
            ServletResponse sresp = (ServletResponse)response;
            ((HttpServletResponse)sresp).setStatus(500);
            response.setError();
            this.status(request, response);
        }
    }

    protected void status(Request request, Response response) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        int statusCode = ((HttpResponse)response).getStatus();
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage != null) {
            this.dispatchToErrorPage(request, response, errorPage, null, null, statusCode);
        } else if (statusCode >= 400 && statusCode < 600 && context.getDefaultErrorPage() != null) {
            this.dispatchToErrorPage(request, response, context.getDefaultErrorPage(), null, null, statusCode);
        } else {
            errorPage = ((StandardHost)this.getContainer()).findErrorPage(statusCode);
            if (errorPage != null) {
                try {
                    this.handleHostErrorPage(response, errorPage, statusCode);
                }
                catch (Exception e) {
                    this.log("Exception processing " + errorPage, e);
                }
            }
        }
    }

    protected static ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.debug >= 1) {
            this.log("Processing " + errorPage);
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        ((HttpRequest)request).setPathInfo(errorPage.getLocation());
        try {
            response.resetBuffer(true);
            Integer statusCodeObj = (Integer)hreq.getAttribute("javax.servlet.error.status_code");
            int statusCode = statusCodeObj;
            String message = (String)hreq.getAttribute("javax.servlet.error.message");
            hres.setStatus(statusCode, message);
            request.lockSession();
            ServletContext servletContext = request.getContext().getServletContext();
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)servletContext.getRequestDispatcher(errorPage.getLocation());
            dispatcher.dispatch((ServletRequest)hreq, (ServletResponse)hres, DispatcherType.ERROR, true);
            response.setSuspended(false);
            boolean bl = true;
            Object var13_14 = null;
            request.unlockSession();
            return bl;
        }
        catch (Throwable t) {
            try {
                this.log("Exception Processing " + errorPage, t);
                boolean bl = false;
                Object var13_15 = null;
                request.unlockSession();
                return bl;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                request.unlockSession();
                throw throwable;
            }
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            log.info(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.toString() + ": " + message, t);
        }
    }

    private void handleHostErrorPage(Response response, ErrorPage errorPage, int statusCode) throws Exception {
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        FileReader reader = null;
        BufferedInputStream istream = null;
        IOException ioe = null;
        String message = errorPage.getReason();
        if (message != null) {
            ((HttpResponse)response).reset(statusCode, message);
        }
        try {
            ostream = response.getResponse().getOutputStream();
        }
        catch (IllegalStateException e) {
            writer = response.getResponse().getWriter();
        }
        if (writer != null) {
            reader = new FileReader(errorPage.getLocation());
            ioe = ResponseUtil.copy(reader, writer);
            try {
                reader.close();
            }
            catch (Throwable t) {}
        } else {
            istream = new BufferedInputStream(new FileInputStream(errorPage.getLocation()));
            ioe = ResponseUtil.copy(istream, ostream);
            try {
                istream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    void setErrorReportValve(GlassFishValve errorReportValve) {
        this.errorReportValve = errorReportValve;
    }

    private Context preInvoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            ((HttpServletResponse)response.getResponse()).sendError(500);
            response.setDetailMessage(sm.getString("standardHost.noContext"));
            return null;
        }
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        hreq.getSession(false);
        return context;
    }

    private void dispatchToErrorPage(Request request, Response response, ErrorPage errorPage, Throwable throwable, Throwable realError, int statusCode) {
        response.setAppCommitted(false);
        ServletRequest sreq = request.getRequest();
        ServletResponse sresp = response.getResponse();
        sreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)errorPage.getLocation());
        sreq.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)sreq).getRequestURI());
        Wrapper wrapper = request.getWrapper();
        if (wrapper != null) {
            sreq.setAttribute("javax.servlet.error.servlet_name", (Object)wrapper.getName());
        }
        if (throwable != null) {
            sreq.setAttribute("javax.servlet.error.status_code", (Object)500);
            sreq.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            sreq.setAttribute("javax.servlet.error.exception", (Object)realError);
            sreq.setAttribute("javax.servlet.error.exception_type", realError.getClass());
        } else {
            sreq.setAttribute("javax.servlet.error.status_code", (Object)statusCode);
            String message = RequestUtil.filter(((HttpResponse)response).getMessage());
            if (message == null) {
                message = "";
            }
            sreq.setAttribute("javax.servlet.error.message", (Object)message);
        }
        if (this.custom(request, response, errorPage)) {
            try {
                sresp.flushBuffer();
            }
            catch (IOException e) {
                this.log("Exception processing " + errorPage, e);
            }
        }
    }
}

