/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    private static Logger log = Logger.getLogger(BasicAuthenticator.class.getName());
    protected static final Base64 base64Helper = new Base64();
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        String realmName;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        if (authorization != null) {
            String username = this.parseUsername(authorization);
            char[] password = this.parsePassword(authorization);
            principal = this.context.getRealm().authenticate(username, password);
            if (principal != null) {
                this.register(request, response, principal, "BASIC", username, password);
                String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
                if (ssoId != null) {
                    this.getSession(request, true);
                }
                return true;
            }
        }
        if ((realmName = config.getRealmName()) == null) {
            realmName = "Authentication required";
        }
        hres.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        hres.sendError(401);
        return false;
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        String unencoded = new String(Base64.decode(authorization.getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String username = unencoded.substring(0, colon);
        return username;
    }

    protected char[] parsePassword(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        String unencoded = new String(Base64.decode(authorization.getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        char[] password = unencoded.substring(colon + 1).toCharArray();
        return password;
    }
}

