/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.C2BConverter;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.apache.catalina.Globals;
import org.apache.catalina.Session;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.RequestUtil;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel {
    private static Logger log = Logger.getLogger(OutputBuffer.class.getName());
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int debug = 0;
    private ByteChunk bb;
    private int state = 0;
    private boolean initial = true;
    private int bytesWritten = 0;
    private int charsWritten = 0;
    private boolean closed = false;
    private boolean doFlush = false;
    private ByteChunk outputChunk = new ByteChunk();
    private String enc;
    private boolean gotEnc = false;
    protected HashMap encoders = new HashMap();
    protected C2BConverter conv;
    private com.sun.grizzly.tcp.Response response;
    private Response coyoteResponse;
    private boolean suspended = false;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(boolean chunkingDisabled) {
        this(8192, chunkingDisabled);
    }

    public OutputBuffer(int size) {
        this(size, false);
    }

    public OutputBuffer(int size, boolean chunkingDisabled) {
        this.bb = new ByteChunk(size);
        if (!chunkingDisabled) {
            this.bb.setLimit(size);
        }
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
    }

    public void setResponse(com.sun.grizzly.tcp.Response response) {
        this.response = response;
    }

    public void setCoyoteResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
        this.setResponse(coyoteResponse.getCoyoteResponse());
    }

    public com.sun.grizzly.tcp.Response getResponse() {
        return this.response;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void recycle() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("recycle()");
        }
        this.initial = true;
        this.bytesWritten = 0;
        this.charsWritten = 0;
        this.bb.recycle();
        this.closed = false;
        this.suspended = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (!this.response.isCommitted() && this.response.getContentLength() == -1 && !this.response.isCommitted()) {
            this.response.setContentLength(this.bb.getLength());
        }
        this.doFlush(false);
        this.closed = true;
        this.response.finish();
    }

    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.suspended) {
            return;
        }
        this.doFlush = true;
        if (this.initial) {
            this.addSessionCookies();
            this.response.sendHeaders();
            this.initial = false;
        }
        if (this.bb.getLength() > 0) {
            this.bb.flushBuffer();
        }
        this.doFlush = false;
        if (realFlush) {
            this.response.action(ActionCode.ACTION_CLIENT_FLUSH, (Object)this.response);
            if (this.response.isExceptionPresent()) {
                throw new ClientAbortException(this.response.getErrorException());
            }
        }
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("realWrite(b, " + off + ", " + cnt + ") " + this.response);
        }
        if (this.closed) {
            return;
        }
        if (this.response == null) {
            return;
        }
        if (cnt > 0) {
            this.addSessionCookies();
            this.outputChunk.setBytes(buf, off, cnt);
            try {
                this.response.doWrite(this.outputChunk);
            }
            catch (IOException e) {
                throw new ClientAbortException(e);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("write(b,off,len)");
        }
        this.bb.append(b, off, len);
        this.bytesWritten += len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.checkConverter();
        this.conv.convert((char)c);
        ++this.charsWritten;
    }

    public void write(char[] c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c, 0, c.length);
    }

    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.checkConverter();
        this.conv.convert(c, off, len);
        this.charsWritten += len;
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.charsWritten += len;
        if (s == null) {
            s = "null";
        }
        this.checkConverter();
        this.conv.convert(s, off, len);
    }

    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s == null) {
            s = "null";
        }
        this.checkConverter();
        this.conv.convert(s);
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    protected void setConverter() throws IOException {
        if (this.response != null) {
            this.enc = this.response.getCharacterEncoding();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Got encoding: " + this.enc);
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = DEFAULT_ENCODING;
        }
        this.conv = (C2BConverter)this.encoders.get(this.enc);
        if (this.conv == null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    this.conv = (C2BConverter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return C2BConverter.getInstance((ByteChunk)OutputBuffer.this.bb, (String)OutputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    Exception e = ex.getException();
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("setConverter: " + ex.getMessage());
                    }
                }
            } else {
                this.conv = C2BConverter.getInstance((ByteChunk)this.bb, (String)this.enc);
            }
            this.encoders.put(this.enc, this.conv);
        }
    }

    public void flushBytes() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("flushBytes() " + this.bb.getLength());
        }
        this.bb.flushBuffer();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    public int getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0 && this.charsWritten == 0;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.bytesWritten = 0;
        this.charsWritten = 0;
        this.gotEnc = false;
        this.enc = null;
        this.initial = true;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }

    private void addSessionCookies() throws IOException {
        Request req = (Request)this.coyoteResponse.getRequest();
        if (req.isRequestedSessionIdFromURL()) {
            return;
        }
        StandardContext ctx = (StandardContext)this.coyoteResponse.getContext();
        if (ctx == null || !ctx.getCookies()) {
            return;
        }
        this.addSessionVersionCookie(req, ctx);
        this.addSessionCookieWithJvmRoute(req, ctx);
        this.addPersistedSessionCookie(req, ctx);
    }

    private void addSessionVersionCookie(Request request, StandardContext context) {
        HashMap sessionVersions = (HashMap)request.getAttribute("com.sun.enterprise.http.sessionVersions");
        if (sessionVersions != null) {
            Cookie cookie = new Cookie("JSESSIONIDVERSION", RequestUtil.createSessionVersionString(sessionVersions));
            request.configureSessionCookie(cookie);
            if (request.isRequestedSessionIdFromCookie()) {
                cookie.setSecure(request.isRequestedSessionIdFromSecureCookie());
            }
            this.response.addHeader(SET_COOKIE_HEADER, this.coyoteResponse.getCookieString(cookie));
        }
    }

    private void addSessionCookieWithJvmRoute(Request request, StandardContext ctx) {
        if (ctx.getJvmRoute() == null) {
            return;
        }
        Session sess = request.getSessionInternal(false);
        if (sess == null) {
            return;
        }
        Cookie cookie = new Cookie(ctx.getSessionCookieName(), sess.getIdInternal() + "." + ctx.getJvmRoute());
        request.configureSessionCookie(cookie);
        this.response.addHeader(SET_COOKIE_HEADER, this.coyoteResponse.getCookieString(cookie));
    }

    private void addPersistedSessionCookie(Request request, StandardContext ctx) throws IOException {
        Session sess = request.getSessionInternal(false);
        if (sess == null) {
            return;
        }
        Cookie cookie = ctx.getManager().toCookie(sess);
        if (cookie != null) {
            request.configureSessionCookie(cookie);
            this.response.addHeader(SET_COOKIE_HEADER, this.coyoteResponse.getCookieString(cookie));
        }
    }

    public boolean hasData() {
        return !this.suspended && (this.initial || this.bb.getLength() > 0);
    }
}

