/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain {
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private StandardWrapper wrapper = null;
    private RequestFacade requestFacade = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private static Class[] classType = new Class[]{ServletRequest.class, ServletResponse.class, FilterChain.class};
    private static Class[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        ApplicationFilterChain.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.wrapper == null) {
            throw new IllegalStateException("Missing wrapper");
        }
        InstanceSupport support = this.wrapper.getInstanceSupport();
        if (this.pos < this.n) {
            ApplicationFilterConfig filterConfig;
            if (!(filterConfig = this.filters[this.pos++]).isAsyncSupported()) {
                this.requestFacade.disableAsyncSupport();
            }
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                support.fireInstanceEvent(InstanceEvent.EventType.BEFORE_FILTER_EVENT, filter, request, response);
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    ServletRequest req = request;
                    ServletResponse res = response;
                    Principal principal = ((HttpServletRequest)req).getUserPrincipal();
                    Object[] filterType = new Object[]{req, res, this};
                    SecurityUtil.doAsPrivilege("doFilter", filter, classType, filterType, principal);
                    filterType = null;
                } else {
                    filter.doFilter(request, response, (FilterChain)this);
                }
                support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response);
            }
            catch (IOException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (ServletException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, (Throwable)e);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    support.fireInstanceEvent(InstanceEvent.EventType.AFTER_FILTER_EVENT, filter, request, response, e);
                }
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        this.wrapper.service(request, response, this.servlet, this.requestFacade);
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        if (this.n == this.filters.length) {
            ApplicationFilterConfig[] newFilters = new ApplicationFilterConfig[this.n + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.wrapper = null;
        this.requestFacade = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setWrapper(StandardWrapper wrapper) {
        this.wrapper = wrapper;
    }

    void setRequestFacade(RequestFacade requestFacade) {
        this.requestFacade = requestFacade;
    }
}

