/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.web.admin.cli.CreateHttp;
import org.glassfish.web.admin.cli.CreateProtocol;
import org.glassfish.web.admin.cli.CreateTransport;
import org.glassfish.web.admin.cli.DeleteNetworkListener;
import org.glassfish.web.admin.cli.DeleteProtocol;
import org.glassfish.web.admin.cli.DeleteTransport;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;

@Service(name="create-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.listener")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttpListener.class);
    @Param(name="listeneraddress")
    String listenerAddress;
    @Param(name="listenerport")
    String listenerPort;
    @Param(name="defaultvs", optional=true)
    String defaultVS;
    @Param(name="default-virtual-server", optional=true)
    String defaultVirtualServer;
    @Param(name="servername", optional=true)
    String serverName;
    @Param(name="xpowered", optional=true, defaultValue="true")
    Boolean xPoweredBy;
    @Param(name="acceptorthreads", optional=true)
    String acceptorThreads;
    @Param(name="redirectport", optional=true)
    String redirectPort;
    @Param(name="securityenabled", optional=true, defaultValue="false")
    Boolean securityEnabled;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean secure;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Habitat habitat;
    @Inject
    CommandRunner runner;
    @Inject
    Logger logger;
    @Inject
    Domain domain;
    private static final String DEFAULT_TRANSPORT = "tcp";
    private NetworkConfig networkConfig = null;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        this.networkConfig = this.config.getNetworkConfig();
        HttpService httpService = this.config.getHttpService();
        if (!(this.verifyUniqueName(report, this.networkConfig) && this.verifyUniquePort(report, this.networkConfig) && this.verifyDefaultVirtualServer(report))) {
            return;
        }
        VirtualServer vs = httpService.getVirtualServerByName(this.defaultVirtualServer);
        boolean listener = false;
        boolean protocol = false;
        boolean transport = false;
        try {
            transport = this.createOrGetTransport(null);
            protocol = this.createProtocol(context);
            this.createHttp(context);
            ThreadPool threadPool = this.getThreadPool(this.networkConfig);
            listener = this.createNetworkListener(this.networkConfig, transport, threadPool);
            this.updateVirtualServer(vs);
        }
        catch (TransactionFailure e) {
            try {
                if (listener) {
                    this.deleteListener(context);
                }
                if (protocol) {
                    this.deleteProtocol(context);
                }
                if (transport) {
                    this.deleteTransport(context);
                }
            }
            catch (Exception e1) {
                this.logger.log(Level.INFO, e.getMessage(), e);
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            this.logger.log(Level.INFO, e.getMessage(), e);
            report.setMessage(localStrings.getLocalString("create.http.listener.fail", "Creation of: " + this.listenerId + "failed because of: " + e.getMessage(), new Object[]{this.listenerId, e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void updateVirtualServer(VirtualServer vs) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

            public Object run(VirtualServer avs) throws PropertyVetoException {
                String DELIM = ",";
                String lss = avs.getNetworkListeners();
                boolean listenerShouldBeAdded = true;
                if (lss == null || lss.length() == 0) {
                    lss = CreateHttpListener.this.listenerId;
                } else if (!lss.contains(CreateHttpListener.this.listenerId)) {
                    if (!lss.endsWith(DELIM)) {
                        lss = lss + DELIM;
                    }
                    lss = lss + CreateHttpListener.this.listenerId;
                } else {
                    listenerShouldBeAdded = false;
                }
                if (listenerShouldBeAdded) {
                    avs.setNetworkListeners(lss);
                }
                return avs;
            }
        }, (ConfigBeanProxy)vs);
    }

    private boolean createNetworkListener(NetworkConfig networkConfig, final boolean newTransport, final ThreadPool threadPool) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners listenersParam) throws TransactionFailure {
                NetworkListener newListener = (NetworkListener)listenersParam.createChild(NetworkListener.class);
                newListener.setName(CreateHttpListener.this.listenerId);
                newListener.setAddress(CreateHttpListener.this.listenerAddress);
                newListener.setPort(CreateHttpListener.this.listenerPort);
                newListener.setTransport(newTransport ? CreateHttpListener.this.listenerId : CreateHttpListener.DEFAULT_TRANSPORT);
                newListener.setProtocol(CreateHttpListener.this.listenerId);
                newListener.setThreadPool(threadPool.getName());
                newListener.setEnabled(CreateHttpListener.this.enabled.toString());
                listenersParam.getNetworkListener().add(newListener);
                return newListener;
            }
        }, (ConfigBeanProxy)networkConfig.getNetworkListeners());
        ((Transactions)this.habitat.getComponent(Transactions.class)).waitForDrain();
        return true;
    }

    private boolean verifyDefaultVirtualServer(ActionReport report) {
        if (this.defaultVS == null && this.defaultVirtualServer == null) {
            report.setMessage(localStrings.getLocalString("create.http.listener.vs.blank", "A default virtual server is required.  Please use --default-virtual-server to specify this value."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.defaultVS != null && this.defaultVirtualServer != null && !this.defaultVS.equals(this.defaultVirtualServer)) {
            report.setMessage(localStrings.getLocalString("create.http.listener.vs.bothparams", "--defaultVS and --default-virtual-server conflict.  Please use only --default-virtual-server to specify this value."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.defaultVirtualServer == null && this.defaultVS != null) {
            this.defaultVirtualServer = this.defaultVS;
        }
        if (!this.defaultVirtualServerExists()) {
            report.setMessage(localStrings.getLocalString("create.http.listener.vs.notexists", "Virtual Server, {0} doesn't exist", new Object[]{this.defaultVirtualServer}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean verifyUniquePort(ActionReport report, NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getPort().trim().equals(this.listenerPort) || !listener.getAddress().trim().equals(this.listenerAddress)) continue;
            String def = "Port is already taken by another listener, choose another port.";
            String msg = localStrings.getLocalString("port.in.use", def, new Object[]{this.listenerPort, listener.getName(), this.listenerAddress});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private boolean verifyUniqueName(ActionReport report, NetworkConfig networkConfig) {
        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
            if (!listener.getName().equals(this.listenerId)) continue;
            report.setMessage(localStrings.getLocalString("create.http.listener.duplicate", "Http Listener named {0} already exists.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    private ThreadPool getThreadPool(NetworkConfig config) {
        List pools = ((Config)config.getParent(Config.class)).getThreadPools().getThreadPool();
        ThreadPool target = null;
        for (ThreadPool pool : pools) {
            if (!"http-thread-pool".equals(pool.getName())) continue;
            target = pool;
        }
        if (target == null && !pools.isEmpty()) {
            target = (ThreadPool)pools.get(0);
        }
        return target;
    }

    private boolean createOrGetTransport(AdminCommandContext context) throws TransactionFailure {
        boolean newTransport = false;
        for (Transport t : this.networkConfig.getTransports().getTransport()) {
            if (t.getName().equals(DEFAULT_TRANSPORT)) continue;
            newTransport = true;
        }
        if (newTransport) {
            CreateTransport command = (CreateTransport)this.runner.getCommand("create-transport", context.getActionReport(), context.getLogger());
            command.transportName = this.listenerId;
            command.acceptorThreads = this.acceptorThreads;
            command.target = this.target;
            command.execute(context);
            this.checkProgress(context);
            newTransport = true;
        }
        return newTransport;
    }

    private boolean createProtocol(AdminCommandContext context) throws TransactionFailure {
        CreateProtocol command = (CreateProtocol)this.runner.getCommand("create-protocol", context.getActionReport(), context.getLogger());
        command.protocolName = this.listenerId;
        command.securityEnabled = this.securityEnabled;
        command.target = this.target;
        command.execute(context);
        this.checkProgress(context);
        return true;
    }

    private boolean createHttp(AdminCommandContext context) throws TransactionFailure {
        CreateHttp command = (CreateHttp)this.runner.getCommand("create-http", context.getActionReport(), context.getLogger());
        command.protocolName = this.listenerId;
        command.defaultVirtualServer = this.defaultVirtualServer;
        command.xPoweredBy = this.xPoweredBy;
        command.serverName = this.serverName;
        command.target = this.target;
        command.execute(context);
        this.checkProgress(context);
        return true;
    }

    private void checkProgress(AdminCommandContext context) throws TransactionFailure {
        if (context.getActionReport().getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            throw new TransactionFailure(context.getActionReport().getMessage());
        }
    }

    private boolean deleteProtocol(AdminCommandContext context) {
        DeleteProtocol command = (DeleteProtocol)this.runner.getCommand("delete-protocol", context.getActionReport(), context.getLogger());
        command.protocolName = this.listenerId;
        command.target = this.target;
        command.execute(context);
        return true;
    }

    private boolean deleteTransport(AdminCommandContext context) {
        DeleteTransport command = (DeleteTransport)this.runner.getCommand("delete-transport", context.getActionReport(), context.getLogger());
        command.transportName = this.listenerId;
        command.target = this.target;
        command.execute(context);
        return true;
    }

    private boolean deleteListener(AdminCommandContext context) {
        DeleteNetworkListener command = (DeleteNetworkListener)this.runner.getCommand("delete-network-listener", context.getActionReport(), context.getLogger());
        command.networkListenerName = this.listenerId;
        command.target = this.target;
        command.execute(context);
        return true;
    }

    private boolean defaultVirtualServerExists() {
        return this.defaultVirtualServer != null && this.config.getHttpService().getVirtualServerByName(this.defaultVirtualServer) != null;
    }
}

