/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.admin.util.Target;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http.listener")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHttpListener.class);
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Param(name="secure", optional=true)
    String secure;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;
    private NetworkConfig networkConfig;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        this.networkConfig = this.config.getNetworkConfig();
        if (!this.exists()) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.notexists", "{0} doesn't exist", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            NetworkListener ls = this.networkConfig.getNetworkListener(this.listenerId);
            String name = ls.getProtocol();
            VirtualServer vs = this.config.getHttpService().getVirtualServerByName(ls.findHttpProtocol().getHttp().getDefaultVirtualServer());
            ConfigSupport.apply((SingleConfigCode)new DeleteNetworkListener(), (ConfigBeanProxy)this.networkConfig.getNetworkListeners());
            ConfigSupport.apply((SingleConfigCode)new UpdateVirtualServer(), (ConfigBeanProxy)vs);
            this.cleanUp(name);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.fail", "failed", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean exists() {
        return this.networkConfig.getNetworkListener(this.listenerId) != null;
    }

    private void cleanUp(String name) throws TransactionFailure {
        boolean found = false;
        for (NetworkListener candidate : this.networkConfig.getNetworkListeners().getNetworkListener()) {
            found |= candidate.getProtocol().equals(name);
        }
        if (!found) {
            ConfigSupport.apply((SingleConfigCode)new DeleteProtocol(name), (ConfigBeanProxy)this.networkConfig.getProtocols());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteProtocol
    implements SingleConfigCode<Protocols> {
        private final String name;

        public DeleteProtocol(String name) {
            this.name = name;
        }

        public Object run(Protocols param) throws PropertyVetoException, TransactionFailure {
            ArrayList list = new ArrayList(param.getProtocol());
            for (Protocol old : list) {
                if (!this.name.equals(old.getName())) continue;
                param.getProtocol().remove(old);
                break;
            }
            return param;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateVirtualServer
    implements SingleConfigCode<VirtualServer> {
        private UpdateVirtualServer() {
        }

        public Object run(VirtualServer avs) throws PropertyVetoException {
            String lss = avs.getNetworkListeners();
            if (lss != null && lss.contains(DeleteHttpListener.this.listenerId)) {
                Pattern p = Pattern.compile(",");
                String[] names = p.split(lss);
                ArrayList<String> nl = new ArrayList<String>();
                for (String name : names) {
                    if (DeleteHttpListener.this.listenerId.equals(name)) continue;
                    nl.add(name);
                }
                lss = ((Object)nl).toString();
                lss = lss.substring(1, lss.length() - 1);
                avs.setNetworkListeners(lss);
            }
            return avs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteNetworkListener
    implements SingleConfigCode<NetworkListeners> {
        private DeleteNetworkListener() {
        }

        public Object run(NetworkListeners param) throws PropertyVetoException, TransactionFailure {
            List list = param.getNetworkListener();
            for (NetworkListener listener : list) {
                if (!listener.getName().equals(DeleteHttpListener.this.listenerId)) continue;
                list.remove(listener);
                break;
            }
            return list;
        }
    }
}

