/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.fileupload;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.catalina.fileupload.PartItem;
import org.apache.catalina.fileupload.ProgressListener;
import org.apache.catalina.fileupload.RequestItem;
import org.apache.catalina.fileupload.RequestItemIterator;
import org.apache.catalina.fileupload.SizeException;
import org.apache.catalina.fileupload.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipart {
    private final String location;
    private final long maxFileSize;
    private final long maxRequestSize;
    private final int fileSizeThreshold;
    private File repository;
    private ProgressListener listener;
    private final HttpServletRequest request;
    private ArrayList<Part> parts;
    private List<Part> unmodifiableParts;

    public Multipart(HttpServletRequest request, String location, long maxFileSize, long maxRequestSize, int fileSizeThreshold) {
        this.request = request;
        this.location = location;
        this.maxFileSize = maxFileSize;
        this.maxRequestSize = maxRequestSize;
        this.fileSizeThreshold = fileSizeThreshold;
        this.repository = (File)request.getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (location != null && location.length() != 0) {
            File tempFile = new File(location);
            this.repository = tempFile.isAbsolute() ? tempFile : new File(this.repository, location);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public int getFileSizeThreshold() {
        return this.fileSizeThreshold;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public File getRepository() {
        return this.repository;
    }

    private boolean isMultipart() {
        if (!this.request.getMethod().toLowerCase().equals("post")) {
            return false;
        }
        String contentType = this.request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/form-data");
    }

    private void initParts() throws IOException, ServletException {
        if (this.parts != null) {
            return;
        }
        this.parts = new ArrayList();
        try {
            RequestItemIterator iter = new RequestItemIterator(this, this.request);
            while (iter.hasNext()) {
                RequestItem requestItem = iter.next();
                PartItem partItem = new PartItem(this, requestItem.getHeaders(), requestItem.getFieldName(), requestItem.getContentType(), requestItem.isFormField(), requestItem.getName());
                Streams.copy(requestItem.openStream(), partItem.getOutputStream(), true);
                this.parts.add(partItem);
            }
        }
        catch (SizeException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public synchronized Collection<Part> getParts() throws IOException, ServletException {
        if (!this.isMultipart()) {
            throw new ServletException("The request content-type is not a multipart/form-data");
        }
        this.initParts();
        if (null == this.unmodifiableParts) {
            this.unmodifiableParts = Collections.unmodifiableList(this.parts);
        }
        return this.unmodifiableParts;
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (!this.isMultipart()) {
            throw new ServletException("The request content-type is not a multipart/form-data");
        }
        this.initParts();
        for (Part part : this.parts) {
            String fieldName = part.getName();
            if (!name.equals(fieldName)) continue;
            return part;
        }
        return null;
    }

    public ProgressListener getProgressListener() {
        return this.listener;
    }

    public void setProgressListener(ProgressListener pListener) {
        this.listener = pListener;
    }
}

