/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.PortUnification;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolFinder;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-protocol-finders")
@Scoped(value=PerLookup.class)
@I18n(value="list.protocol.finders")
@Cluster(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class ListProtocolFinders
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListProtocolFinders.class);
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="protocol", primary=true)
    String protocolName;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocol protocol = this.config.getNetworkConfig().getProtocols().findProtocol(this.protocolName);
        PortUnification pu = protocol.getPortUnification();
        for (ProtocolFinder finder : pu.getProtocolFinder()) {
            report.getTopMessagePart().addChild().setMessage(finder.getName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

