/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ha.util.PersistenceTypeResolver;
import com.sun.enterprise.web.MemoryStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.jvnet.hk2.component.Habitat;

public class PersistenceStrategyBuilderFactory {
    private static final Logger _logger = LogDomains.getLogger(PersistenceStrategyBuilderFactory.class, (String)"javax.enterprise.system.container.web");
    Habitat habitat;
    private String _eeBuilderPath = null;
    private ServerConfigLookup serverConfigLookup;

    public PersistenceStrategyBuilderFactory(ServerConfigLookup serverConfigLookup, Habitat habitat) {
        this.serverConfigLookup = serverConfigLookup;
        this.habitat = habitat;
        this._eeBuilderPath = serverConfigLookup.getEEBuilderPathFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("_eeBuilderPath = " + this._eeBuilderPath);
        }
    }

    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope, Context ctx) {
        PersistenceStrategyBuilder builder;
        String resolvedPersistenceType = "memory";
        String resolvedPersistenceFrequency = null;
        String resolvedPersistenceScope = null;
        PersistenceTypeResolver persistenceTypeResolver = this.getPersistenceTypeResolver();
        if (persistenceTypeResolver != null) {
            resolvedPersistenceType = persistenceTypeResolver.resolvePersistenceType(persistenceType);
        } else if (persistenceType != null) {
            resolvedPersistenceType = persistenceType;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Resolved persistence type is " + resolvedPersistenceType);
        }
        if (!(resolvedPersistenceType.equalsIgnoreCase(PersistenceType.MEMORY.getType()) || resolvedPersistenceType.equalsIgnoreCase(PersistenceType.FILE.getType()) || resolvedPersistenceType.equalsIgnoreCase(PersistenceType.COOKIE.getType()))) {
            resolvedPersistenceFrequency = frequency;
            resolvedPersistenceScope = scope;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("resolvedPersistenceType = " + resolvedPersistenceType);
            _logger.finest("resolvedPersistenceFrequency = " + resolvedPersistenceFrequency);
            _logger.finest("resolvedPersistenceScope = " + resolvedPersistenceScope);
        }
        if (this.habitat == null && _logger.isLoggable(Level.FINEST)) {
            _logger.finest("Habitat is null");
        }
        if ((builder = (PersistenceStrategyBuilder)this.habitat.getComponent(PersistenceStrategyBuilder.class, resolvedPersistenceType)) == null) {
            builder = new MemoryStrategyBuilder();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Could not find PersistentStrategyBuilder for persistenceType  " + resolvedPersistenceType);
            }
        } else {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + builder.getClass());
            }
            builder.setPersistenceFrequency(frequency);
            builder.setPersistenceScope(scope);
            builder.setPassedInPersistenceType(persistenceType);
        }
        return builder;
    }

    PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope) {
        String passedInPersistenceType = persistenceType;
        PersistenceStrategyBuilder builder = (PersistenceStrategyBuilder)this.habitat.getComponent(PersistenceStrategyBuilder.class, persistenceType);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + builder.getClass());
        }
        builder.setPersistenceFrequency(frequency);
        builder.setPersistenceScope(scope);
        builder.setPassedInPersistenceType(passedInPersistenceType);
        return builder;
    }

    private PersistenceTypeResolver getPersistenceTypeResolver() {
        String resolverClassName = "com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver";
        PersistenceTypeResolver persistenceTypeResolver = null;
        try {
            persistenceTypeResolver = (PersistenceTypeResolver)Class.forName(resolverClassName).newInstance();
        }
        catch (Exception ex) {
            _logger.finest("unable to create persistence type resolver");
        }
        return persistenceTypeResolver;
    }

    public String getApplicationId(Context ctx) {
        return ((WebModule)ctx).getID();
    }
}

