/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSignOnEntry {
    private static final Logger log = Logger.getLogger(SingleSignOnEntry.class.getName());
    protected String id = null;
    protected String authType = null;
    protected char[] password = null;
    protected Principal principal = null;
    protected Session[] sessions = new Session[0];
    protected String username = null;
    protected String realmName = null;
    protected long lastAccessTime;

    public SingleSignOnEntry(String id, Principal principal, String authType, String username, char[] password, String realmName) {
        this.id = id;
        this.principal = principal;
        this.authType = authType;
        this.username = username;
        this.password = password != null ? (char[])password.clone() : null;
        this.realmName = realmName;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session != this.sessions[i]) continue;
            return false;
        }
        Session[] results = new Session[this.sessions.length + 1];
        System.arraycopy(this.sessions, 0, results, 0, this.sessions.length);
        results[this.sessions.length] = session;
        this.sessions = results;
        session.addSessionListener(sso);
        return true;
    }

    public synchronized void removeSession(Session session) {
        Session[] nsessions = new Session[this.sessions.length - 1];
        int j = 0;
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session == this.sessions[i]) continue;
            nsessions[j++] = this.sessions[i];
        }
        this.sessions = nsessions;
    }

    public synchronized boolean isEmpty() {
        return this.sessions.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expireSessions(Map<Session, String> reverse) {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(" Invalidating session " + this.sessions[i]);
            }
            Map<Session, String> map = reverse;
            synchronized (map) {
                reverse.remove(this.sessions[i]);
            }
            if (!this.sessions[i].getIsValid()) continue;
            this.sessions[i].expire();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getAuthType() {
        return this.authType;
    }

    public char[] getPassword() {
        return this.password;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }
}

