/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.util.ProcessEnvironment;

public class CGIProcessEnvironment
extends ProcessEnvironment {
    private static Logger log = Logger.getLogger(CGIProcessEnvironment.class.getName());
    private Hashtable queryParameters = null;
    private String cgiPathPrefix = null;

    public CGIProcessEnvironment(HttpServletRequest req, ServletContext context) {
        this(req, context, "");
    }

    public CGIProcessEnvironment(HttpServletRequest req, ServletContext context, String cgiPathPrefix) {
        this(req, context, cgiPathPrefix, 0);
    }

    public CGIProcessEnvironment(HttpServletRequest req, ServletContext context, int debug) {
        this(req, context, "", 0);
    }

    public CGIProcessEnvironment(HttpServletRequest req, ServletContext context, String cgiPathPrefix, int debug) {
        super(req, context, debug);
        this.cgiPathPrefix = cgiPathPrefix;
        this.queryParameters = new Hashtable();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames != null && paramNames.hasMoreElements()) {
            String param = paramNames.nextElement().toString();
            if (param == null) continue;
            this.queryParameters.put(param, URLEncoder.encode(req.getParameter(param)));
        }
        this.valid = this.deriveProcessEnvironment(req);
    }

    protected boolean deriveProcessEnvironment(HttpServletRequest req) {
        super.deriveProcessEnvironment(req);
        Hashtable envp = this.getEnvironment();
        String sPathInfoOrig = null;
        String sPathTranslatedOrig = null;
        String sPathInfoCGI = null;
        String sPathTranslatedCGI = null;
        String sCGIFullPath = null;
        String sCGIScriptName = null;
        String sCGIFullName = null;
        String sCGIName = null;
        sPathInfoOrig = this.pathInfo;
        sPathInfoOrig = sPathInfoOrig == null ? "" : sPathInfoOrig;
        sPathTranslatedOrig = req.getPathTranslated();
        sPathTranslatedOrig = sPathTranslatedOrig == null ? "" : sPathTranslatedOrig;
        String[] sCGINames = this.findCGI(sPathInfoOrig, this.getWebAppRootDir(), this.getContextPath(), this.getServletPath(), this.cgiPathPrefix);
        sCGIFullPath = sCGINames[0];
        sCGIScriptName = sCGINames[1];
        sCGIFullName = sCGINames[2];
        sCGIName = sCGINames[3];
        if (sCGIFullPath == null || sCGIScriptName == null || sCGIFullName == null || sCGIName == null) {
            return false;
        }
        envp.put("SERVER_SOFTWARE", "TOMCAT");
        envp.put("SERVER_NAME", this.nullsToBlanks(req.getServerName()));
        envp.put("GATEWAY_INTERFACE", "CGI/1.1");
        envp.put("SERVER_PROTOCOL", this.nullsToBlanks(req.getProtocol()));
        int port = req.getServerPort();
        Integer iPort = port == 0 ? Integer.valueOf(-1) : Integer.valueOf(port);
        envp.put("SERVER_PORT", iPort.toString());
        envp.put("REQUEST_METHOD", this.nullsToBlanks(req.getMethod()));
        sPathInfoCGI = this.pathInfo == null || this.pathInfo.substring(sCGIFullName.length()).length() <= 0 ? "" : this.pathInfo.substring(sCGIFullName.length());
        envp.put("PATH_INFO", sPathInfoCGI);
        sPathTranslatedCGI = sPathInfoCGI != null && !"".equals(sPathInfoCGI) ? this.getContext().getRealPath(sPathInfoCGI) : null;
        if (sPathTranslatedCGI != null && !"".equals(sPathTranslatedCGI)) {
            envp.put("PATH_TRANSLATED", this.nullsToBlanks(sPathTranslatedCGI));
        }
        envp.put("SCRIPT_NAME", this.nullsToBlanks(sCGIScriptName));
        envp.put("QUERY_STRING", this.nullsToBlanks(req.getQueryString()));
        envp.put("REMOTE_HOST", this.nullsToBlanks(req.getRemoteHost()));
        envp.put("REMOTE_ADDR", this.nullsToBlanks(req.getRemoteAddr()));
        envp.put("AUTH_TYPE", this.nullsToBlanks(req.getAuthType()));
        envp.put("REMOTE_USER", this.nullsToBlanks(req.getRemoteUser()));
        envp.put("REMOTE_IDENT", "");
        envp.put("CONTENT_TYPE", this.nullsToBlanks(req.getContentType()));
        int contentLength = req.getContentLength();
        String sContentLength = contentLength <= 0 ? "" : Integer.valueOf(contentLength).toString();
        envp.put("CONTENT_LENGTH", sContentLength);
        Enumeration headers = req.getHeaderNames();
        String header = null;
        while (headers.hasMoreElements()) {
            header = null;
            header = ((String)headers.nextElement()).toUpperCase(Locale.ENGLISH);
            if ("AUTHORIZATION".equalsIgnoreCase(header) || "PROXY_AUTHORIZATION".equalsIgnoreCase(header)) continue;
            if ("HOST".equalsIgnoreCase(header)) {
                String host = req.getHeader(header);
                envp.put("HTTP_" + header.replace('-', '_'), host.substring(0, host.indexOf(":")));
                continue;
            }
            envp.put("HTTP_" + header.replace('-', '_'), req.getHeader(header));
        }
        this.command = sCGIFullPath;
        this.workingDirectory = new File(this.command.substring(0, this.command.lastIndexOf(File.separator)));
        envp.put("X_TOMCAT_COMMAND_PATH", this.command);
        this.setEnvironment(envp);
        return true;
    }

    protected String[] findCGI(String pathInfo, String webAppRootDir, String contextPath, String servletPath, String cgiPathPrefix) {
        String path = null;
        String name = null;
        String scriptname = null;
        String cginame = null;
        if (webAppRootDir != null && webAppRootDir.lastIndexOf("/") == webAppRootDir.length() - 1) {
            webAppRootDir = webAppRootDir.substring(0, webAppRootDir.length() - 1);
        }
        if (cgiPathPrefix != null) {
            webAppRootDir = webAppRootDir + File.separator + cgiPathPrefix;
        }
        if (this.debug >= 2) {
            this.log("findCGI: start = [" + webAppRootDir + "], pathInfo = [" + pathInfo + "] ");
        }
        File currentLocation = new File(webAppRootDir);
        StringTokenizer dirWalker = new StringTokenizer(pathInfo, "/");
        while (!currentLocation.isFile() && dirWalker.hasMoreElements()) {
            currentLocation = new File(currentLocation, (String)dirWalker.nextElement());
            if (this.debug < 3) continue;
            this.log("findCGI: traversing to [" + currentLocation + "]");
        }
        if (!currentLocation.isFile()) {
            return new String[]{null, null, null, null};
        }
        if (this.debug >= 2) {
            this.log("findCGI: FOUND cgi at [" + currentLocation + "]");
        }
        path = currentLocation.getAbsolutePath();
        name = currentLocation.getName();
        cginame = currentLocation.getParent().substring(webAppRootDir.length()) + File.separator + name;
        scriptname = ".".equals(contextPath) ? servletPath + cginame : contextPath + servletPath + cginame;
        if (this.debug >= 1) {
            this.log("findCGI calc: name=" + name + ", path=" + path + ", scriptname=" + scriptname + ", cginame=" + cginame);
        }
        return new String[]{path, scriptname, cginame, name};
    }

    public String toString() {
        String s;
        StringBuilder sb = new StringBuilder();
        sb.append("<TABLE border=2>");
        sb.append("<tr><th colspan=2 bgcolor=grey>");
        sb.append("ProcessEnvironment Info</th></tr>");
        sb.append("<tr><td>Debug Level</td><td>");
        sb.append(this.debug);
        sb.append("</td></tr>");
        sb.append("<tr><td>Validity:</td><td>");
        sb.append(this.isValid());
        sb.append("</td></tr>");
        if (this.isValid()) {
            Enumeration envk = this.env.keys();
            while (envk.hasMoreElements()) {
                s = (String)envk.nextElement();
                sb.append("<tr><td>");
                sb.append(s);
                sb.append("</td><td>");
                sb.append(this.blanksToString((String)this.env.get(s), "[will be set to blank]"));
                sb.append("</td></tr>");
            }
        }
        sb.append("<tr><td colspan=2><HR></td></tr>");
        sb.append("<tr><td>Derived Command</td><td>");
        sb.append(this.nullsToBlanks(this.command));
        sb.append("</td></tr>");
        sb.append("<tr><td>Working Directory</td><td>");
        if (this.workingDirectory != null) {
            sb.append(this.workingDirectory.toString());
        }
        sb.append("</td></tr>");
        sb.append("<tr><td colspan=2>Query Params</td></tr>");
        Enumeration paramk = this.queryParameters.keys();
        while (paramk.hasMoreElements()) {
            s = paramk.nextElement().toString();
            sb.append("<tr><td>");
            sb.append(s);
            sb.append("</td><td>");
            sb.append(this.queryParameters.get(s).toString());
            sb.append("</td></tr>");
        }
        sb.append("</TABLE><p>end.");
        return sb.toString();
    }

    public Hashtable getParameters() {
        return this.queryParameters;
    }
}

