/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.ServerConfigLookup;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.web.ha.authenticator.HASingleSignOn;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class HASSOFactory
implements SSOFactory {
    private static BackingStore ssoEntryMetadataBackingStore = null;
    @Inject
    private Habitat habitat;
    @Inject
    private GMSAdapterService gmsAdapterService;
    @Inject
    private ServerConfigLookup serverConfigLookup;
    @Inject
    private JavaEEIOUtils ioUtils;

    public GlassFishSingleSignOn createSingleSignOnValve(String virtualServerName) {
        if (this.isSsoFailoverEnabled()) {
            return new HASingleSignOn(this.ioUtils, this.getSsoEntryMetadataBackingStore("file", "SSOStore"));
        }
        return new GlassFishSingleSignOn();
    }

    private boolean isSsoFailoverEnabled() {
        boolean webContainerAvailabilityEnabled = this.serverConfigLookup.getWebContainerAvailabilityEnabledFromConfig();
        boolean isSsoFailoverEnabled = this.serverConfigLookup.isSsoFailoverEnabledFromConfig();
        return isSsoFailoverEnabled && webContainerAvailabilityEnabled;
    }

    protected synchronized BackingStore getSsoEntryMetadataBackingStore(String persistenceType, String storeName) {
        if (ssoEntryMetadataBackingStore == null) {
            BackingStoreFactory factory = (BackingStoreFactory)this.habitat.getComponent(BackingStoreFactory.class, "replication");
            BackingStoreConfiguration conf = new BackingStoreConfiguration();
            String clusterName = "";
            String instanceName = "";
            if (this.gmsAdapterService.isGmsEnabled()) {
                clusterName = this.gmsAdapterService.getGMSAdapter().getClusterName();
                instanceName = this.gmsAdapterService.getGMSAdapter().getModule().getInstanceName();
            }
            conf.setStoreName(storeName).setClusterName(clusterName).setInstanceName(instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(HASingleSignOnEntryMetadata.class);
            try {
                ssoEntryMetadataBackingStore = factory.createBackingStore(conf);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return ssoEntryMetadataBackingStore;
    }
}

