/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleDecorator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.glassfish.osgijavaeebase.BundleResource;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgiweb.OSGiWebContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiWebModuleDecorator
implements WebModuleDecorator {
    private volatile OSGiWebContainer wc;

    public OSGiWebModuleDecorator(OSGiWebContainer wc) {
        this.wc = wc;
    }

    public void decorate(WebModule module) {
        BundleContext bctx;
        if (this.wc != null && (bctx = this.wc.getCurrentBundleContext()) != null) {
            ServletContext sc = module.getServletContext();
            sc.setAttribute("osgi-bundlecontext", (Object)bctx);
            ArrayList<URL> facesConfigs = new ArrayList<URL>();
            ArrayList<URL> faceletConfigs = new ArrayList<URL>();
            this.discoverJSFConfigs(bctx.getBundle(), facesConfigs, faceletConfigs);
            sc.setAttribute("glassfish.osgi.web.facesconfigs", facesConfigs);
            sc.setAttribute("glassfish.osgi.web.faceletconfigs", faceletConfigs);
        }
    }

    void setWc(OSGiWebContainer wc) {
        this.wc = wc;
    }

    private void discoverJSFConfigs(Bundle b, Collection<URL> facesConfigs, Collection<URL> faceletConfigs) {
        OSGiBundleArchive archive = new OSGiBundleArchive(b);
        for (BundleResource r : archive) {
            String path = r.getPath();
            if (!path.startsWith("META-INF/")) continue;
            try {
                URL url = r.getUri().toURL();
                if (path.endsWith(".taglib.xml")) {
                    faceletConfigs.add(url);
                    continue;
                }
                if (!"META-INF/faces-config.xml".equals(path) && !path.endsWith(".faces-config.xml")) continue;
                facesConfigs.add(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

