/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicationSessionMonitors {
    private ConcurrentHashMap replicatedSessionMonitors = null;
    private ReferenceQueue replicatedSessionMonitorsRefQueue = new ReferenceQueue();
    private static final int CONCURRENCY_LEVEL = 100;
    private final Logger _logger;

    public ReplicationSessionMonitors(Logger logger, int size, float loadFactor) {
        this._logger = logger;
        this.replicatedSessionMonitors = new ConcurrentHashMap(size, loadFactor, 100);
        this.replicatedSessionMonitorsRefQueue = new ReferenceQueue();
    }

    public Object get(String id) {
        Object result = null;
        Reference resultRef = (Reference)this.replicatedSessionMonitors.get(id);
        if (resultRef != null) {
            result = resultRef.get();
            if (result != null) {
                return result;
            }
            this.remove(id, resultRef);
            return this.get(id);
        }
        Object keepReachable = new Object();
        KeyedReference ref = new KeyedReference(keepReachable, this.replicatedSessionMonitorsRefQueue, id);
        Reference refToResult = this.replicatedSessionMonitors.putIfAbsent(id, ref);
        if (refToResult == null) {
            return keepReachable;
        }
        result = refToResult.get();
        if (result != null) {
            return result;
        }
        this.remove(id, refToResult);
        return this.get(id);
    }

    private Object remove(String id, Object toRemove) {
        boolean removed = this.replicatedSessionMonitors.remove(id, toRemove);
        if (removed) {
            ((KeyedReference)toRemove).key = null;
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("replicatedSession monitors remove id=" + id + " succeeded=" + removed);
        }
        return removed;
    }

    private void assertOnReferenceQueue(KeyedReference ref) {
        if (this._logger.isLoggable(Level.FINE) && ref.get() != null) {
            this._logger.fine("assertion failed: monitor for session id: " + ref.key + " was on ReferenceQueue but it" + " but its get() returned non-null");
        }
    }

    public void processExpired() {
        int exitSize;
        KeyedReference toBeRemoved = null;
        while ((toBeRemoved = (KeyedReference)this.replicatedSessionMonitorsRefQueue.poll()) != null) {
            if (toBeRemoved.key == null) continue;
            this.assertOnReferenceQueue(toBeRemoved);
            Object removed = this.remove(toBeRemoved.key, toBeRemoved);
            if (removed != null || !this._logger.isLoggable(Level.FINE)) continue;
            this._logger.fine("processExpiredReplicaMonitor: unable to remove " + toBeRemoved + " sessionId=" + toBeRemoved.key);
        }
        if (this._logger.isLoggable(Level.FINER) && (exitSize = this.replicatedSessionMonitors.size()) != 0) {
            this._logger.finer("exit ReplicationSessionMonitors.processExpired numberOfEntries=" + exitSize);
            if (this._logger.isLoggable(Level.FINEST)) {
                int i = 1;
                for (Object keyRef : this.replicatedSessionMonitors.values()) {
                    this._logger.finest("ReplicationSessionMonitors.processExpired: replicatedSessionMonitor[" + i + "]: " + (KeyedReference)keyRef);
                    ++i;
                }
            }
        }
    }

    private static class KeyedReference
    extends WeakReference {
        private String key;

        private KeyedReference(Object objRef, ReferenceQueue q, String key) {
            super(objRef, q);
            this.key = key;
        }

        public String toString() {
            return "key=" + this.key + " resolvesTo=" + this.get();
        }
    }
}

