/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.web.WebModuleDecorator;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijavaeebase.ExtenderManager;
import org.glassfish.osgiweb.OSGiWebContainer;
import org.glassfish.osgiweb.OSGiWebModuleDecorator;
import org.glassfish.osgiweb.WebBundleURLStreamHandlerService;
import org.jvnet.hk2.component.Inhabitant;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class WebExtender
implements Extender,
BundleListener {
    private OSGiWebContainer wc;
    private static final Logger logger = Logger.getLogger(ExtenderManager.class.getPackage().getName());
    private BundleContext context;
    private AtomicBoolean started = new AtomicBoolean(false);
    private ServiceRegistration urlHandlerService;
    private OSGiWebModuleDecorator wmd;

    public WebExtender(BundleContext context) {
        this.context = context;
    }

    public void start() {
        if (this.started.getAndSet(true)) {
            return;
        }
        this.wc = new OSGiWebContainer(this.context);
        this.registerWmd();
        this.context.addBundleListener((BundleListener)this);
        for (Bundle b : this.context.getBundles()) {
            if (!this.isWebBundle(b) || !this.isReady(b)) continue;
            this.deploy(b);
        }
        this.addURLHandler();
    }

    public void stop() {
        if (this.started.getAndSet(false)) {
            this.removeURLHandler();
            this.context.removeBundleListener((BundleListener)this);
            this.unregisterWmd();
            if (this.wc != null) {
                this.wc.undeployAll();
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                if (this.isLazy(bundle) || !this.isWebBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 512: {
                if (!this.isWebBundle(bundle)) break;
                this.deploy(bundle);
                break;
            }
            case 4: {
                if (!this.isWebBundle(bundle) || !this.wc.isDeployed(bundle)) break;
                this.undeploy(bundle);
            }
        }
    }

    private boolean isLazy(Bundle bundle) {
        return "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"));
    }

    private boolean isReady(Bundle b) {
        int state = b.getState();
        boolean isActive = (state & 0x20) != 0;
        boolean isStarting = (state & 8) != 0;
        boolean isReady = isActive || this.isLazy(b) && isStarting;
        return isReady;
    }

    private boolean isWebBundle(Bundle b) {
        Dictionary headers = b.getHeaders();
        return headers.get("Web-ContextPath") != null && headers.get("Fragment-Host") == null;
    }

    private void deploy(Bundle b) {
        try {
            this.wc.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "WebExtender", "deploy", "Exception deploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "WebExtender", "deploy", "Exception Stack Trace", e);
        }
    }

    private void undeploy(Bundle b) {
        try {
            this.wc.undeploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "WebExtender", "undeploy", "Exception undeploying bundle {0}", new Object[]{b.getLocation()});
            logger.logp(Level.SEVERE, "WebExtender", "undeploy", "Exception Stack Trace", e);
        }
    }

    private void addURLHandler() {
        Properties p = new Properties();
        p.put("url.handler.protocol", new String[]{"webbundle"});
        this.urlHandlerService = this.context.registerService(URLStreamHandlerService.class.getName(), (Object)new WebBundleURLStreamHandlerService(), (Dictionary)p);
    }

    private void removeURLHandler() {
        if (this.urlHandlerService != null) {
            this.urlHandlerService.unregister();
        }
    }

    private void registerWmd() {
        assert (this.wc != null);
        this.wmd = new OSGiWebModuleDecorator(this.wc);
        ExistingSingletonInhabitant i = new ExistingSingletonInhabitant((Object)this.wmd);
        String fqcn = WebModuleDecorator.class.getName();
        Globals.getDefaultHabitat().addIndex((Inhabitant)i, fqcn, this.wmd.getClass().getSimpleName());
    }

    private void unregisterWmd() {
        this.wmd.setWc(null);
    }
}

