/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.web.WebModuleDecorator;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgiweb.OSGiWebDeployer;
import org.glassfish.osgiweb.OSGiWebModuleDecorator;
import org.glassfish.osgiweb.WebBundleURLStreamHandlerService;
import org.jvnet.hk2.component.Inhabitant;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class WebExtender
implements Extender {
    private static final Logger logger = Logger.getLogger(WebExtender.class.getPackage().getName());
    private BundleContext context;
    private ServiceRegistration urlHandlerService;
    private OSGiWebModuleDecorator wmd;
    private OSGiWebDeployer deployer;

    public WebExtender(BundleContext context) {
        this.context = context;
    }

    public synchronized void start() {
        this.registerWmd();
        this.registerDeployer();
        this.addURLHandler();
    }

    public synchronized void stop() {
        this.removeURLHandler();
        this.unregisterDeployer();
        this.unregisterWmd();
    }

    private void registerDeployer() {
        this.deployer = new OSGiWebDeployer(this.context);
        this.deployer.register();
    }

    private void unregisterDeployer() {
        if (this.deployer != null) {
            this.deployer.unregister();
            this.deployer = null;
        }
    }

    private void addURLHandler() {
        Properties p = new Properties();
        p.put("url.handler.protocol", new String[]{"webbundle"});
        this.urlHandlerService = this.context.registerService(URLStreamHandlerService.class.getName(), (Object)new WebBundleURLStreamHandlerService(), (Dictionary)p);
    }

    private void removeURLHandler() {
        if (this.urlHandlerService != null) {
            this.urlHandlerService.unregister();
        }
    }

    private void registerWmd() {
        this.wmd = new OSGiWebModuleDecorator();
        ExistingSingletonInhabitant i = new ExistingSingletonInhabitant((Object)this.wmd);
        String fqcn = WebModuleDecorator.class.getName();
        Globals.getDefaultHabitat().addIndex((Inhabitant)i, fqcn, this.wmd.getClass().getSimpleName());
    }

    private void unregisterWmd() {
        if (this.wmd == null) {
            return;
        }
        this.wmd.deActivate();
    }
}

