/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static Logger log = Logger.getLogger(ApplicationFilterConfig.class.getName());
    private StandardContext context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;
    private boolean needInitialize = true;

    public ApplicationFilterConfig(StandardContext context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public boolean isAsyncSupported() {
        return this.filterDef.isAsyncSupported();
    }

    public String getInitParameter(String name) {
        return this.filterDef.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.filterDef.getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClassName());
        sb.append("]");
        return sb.toString();
    }

    synchronized Filter getFilter() throws Exception {
        if (this.filter != null && !this.needInitialize) {
            return this.filter;
        }
        if (this.filter == null) {
            Class<Object> clazz = this.filterDef.getFilterClass();
            if (clazz == null) {
                ClassLoader classLoader = null;
                String filterClassName = this.filterDef.getFilterClassName();
                classLoader = filterClassName.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
                ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader.loadClass(filterClassName);
            }
            this.filter = this.context.createFilterInstance(clazz);
        }
        if (this.context != null) {
            this.context.fireContainerEvent("beforeFilterInitialized", this.filter);
        }
        this.filter.init((FilterConfig)this);
        this.needInitialize = false;
        if (this.context != null) {
            this.context.fireContainerEvent("afterFilterInitialized", this.filter);
        }
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            if (this.context != null) {
                this.context.fireContainerEvent("beforeFilterDestroyed", this.filter);
            }
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                    SecurityUtil.remove(this.filter);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "ApplicationFilterConfig.doAsPrivilege", ex);
                }
            } else {
                this.filter.destroy();
            }
            if (this.context != null) {
                this.context.fireContainerEvent("afterFilterDestroyed", this.filter);
                this.context = null;
            }
        }
        this.filter = null;
        this.needInitialize = true;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                        SecurityUtil.remove(this.filter);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "ApplicationFilterConfig.doAsPrivilege", ex);
                    }
                } else {
                    this.filter.destroy();
                }
            }
            this.filter = null;
        } else {
            this.filter = filterDef.getFilter();
        }
    }
}

