/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.MD5Encoder;

public class DigestAuthenticator
extends AuthenticatorBase {
    protected static final int USE_ONCE = 1;
    protected static final int USE_NEVER_EXPIRES = Integer.MAX_VALUE;
    protected static final int TIMEOUT_INFINITE = Integer.MAX_VALUE;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static volatile MessageDigest md5Helper;
    protected Hashtable nOnceTokens = new Hashtable();
    protected long nOnceTimeout = Integer.MAX_VALUE;
    protected int nOnceUses = 1;
    protected String key = "Catalina";

    public DigestAuthenticator() {
        try {
            if (md5Helper == null) {
                md5Helper = MessageDigest.getInstance("MD5");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 digest algorithm not available", e);
        }
    }

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        if (authorization != null && (principal = this.context.getRealm().authenticate(hreq)) != null) {
            String username = this.parseUsername(authorization);
            this.register(request, response, principal, "DIGEST", username, null);
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (ssoId != null) {
                this.getSession(request, true);
            }
            return true;
        }
        String nOnce = this.generateNOnce(hreq);
        this.setAuthenticateHeader(hreq, hres, config, nOnce);
        hres.sendError(401);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Principal findPrincipal(HttpServletRequest request, String authorization, Realm realm) {
        Object currentTokenName;
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        Object opaque = null;
        String method = request.getMethod();
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = currentTokenValue;
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        byte[] buffer = null;
        currentTokenName = md5Helper;
        synchronized (currentTokenName) {
            buffer = md5Helper.digest(a2.getBytes());
        }
        char[] md5a2 = md5Encoder.encode(buffer);
        char[] responseCharArray = response != null ? response.toCharArray() : null;
        return realm.authenticate(userName, responseCharArray, nOnce, nc, cnonce, qop, realmName, md5a2);
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return new String();
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    protected String generateNOnce(HttpServletRequest request) {
        long currentTime = System.currentTimeMillis();
        String nOnceValue = request.getRemoteAddr() + ":" + currentTime + ":" + this.key;
        byte[] buffer = md5Helper.digest(nOnceValue.getBytes());
        nOnceValue = String.valueOf(md5Encoder.encode(buffer));
        this.nOnceTokens.put(nOnceValue, currentTime + this.nOnceTimeout);
        return nOnceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, LoginConfig config, String nOnce) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = "Authentication required";
        }
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnce.getBytes());
        }
        String authenticateHeader = "Digest realm=\"" + realmName + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + String.valueOf(md5Encoder.encode(buffer)) + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }
}

