/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.strategy.builder;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.web.BasePersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import java.util.HashMap;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.session.management.CompositeMetadata;
import org.glassfish.web.ha.session.management.FullSessionFactory;
import org.glassfish.web.ha.session.management.HASessionStoreValve;
import org.glassfish.web.ha.session.management.ModifiedAttributeSessionFactory;
import org.glassfish.web.ha.session.management.ModifiedSessionFactory;
import org.glassfish.web.ha.session.management.ReplicationAttributeStore;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.ReplicationWebEventPersistentManager;
import org.glassfish.web.ha.session.management.SimpleMetadata;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="replicated")
@Scoped(value=PerLookup.class)
public class ReplicatedWebMethodSessionStrategyBuilder
extends BasePersistenceStrategyBuilder {
    @Inject
    ReplicationWebEventPersistentManager rwepMgr;
    @Inject
    JavaEEIOUtils ioUtils;

    public void initializePersistenceStrategy(Context ctx, SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        super.initializePersistenceStrategy(ctx, smBean, serverConfigLookup);
        ReplicationStore store = null;
        HashMap<String, Boolean> vendorMap = new HashMap<String, Boolean>();
        boolean asyncReplicationValue = serverConfigLookup.getAsyncReplicationFromConfig((WebModule)ctx);
        vendorMap.put("async.replication", asyncReplicationValue);
        if (this.getPersistenceScope().equals("session")) {
            this.rwepMgr.setSessionFactory(new FullSessionFactory());
            store = new ReplicationStore(serverConfigLookup, this.ioUtils);
            this.rwepMgr.createBackingStore(this.getPassedInPersistenceType(), ctx.getPath(), SimpleMetadata.class, vendorMap);
        } else if (this.getPersistenceScope().equals("modified-session")) {
            this.rwepMgr.setSessionFactory(new ModifiedSessionFactory());
            store = new ReplicationStore(serverConfigLookup, this.ioUtils);
            this.rwepMgr.createBackingStore(this.getPassedInPersistenceType(), ctx.getPath(), SimpleMetadata.class, vendorMap);
        } else if (this.getPersistenceScope().equals("modified-attribute")) {
            this.rwepMgr.setSessionFactory(new ModifiedAttributeSessionFactory());
            store = new ReplicationAttributeStore(serverConfigLookup, this.ioUtils);
            this.rwepMgr.createBackingStore(this.getPassedInPersistenceType(), ctx.getPath(), CompositeMetadata.class, vendorMap);
        }
        this.rwepMgr.setStore((Store)store);
        ctx.setManager((Manager)this.rwepMgr);
        HASessionStoreValve haValve = new HASessionStoreValve();
        StandardContext stdCtx = (StandardContext)ctx;
        stdCtx.addValve((GlassFishValve)haValve);
    }
}

