/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionLocker;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.BaseSessionLocker;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;

public abstract class ManagerBase
implements Manager,
MBeanRegistration {
    protected Logger log = Logger.getLogger(ManagerBase.class.getName());
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected Container container;
    protected int debug = 0;
    protected DefaultContext defaultContext = null;
    protected boolean distributable;
    protected String entropy = null;
    protected SessionLocker sessionLocker = new BaseSessionLocker();
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected int sessionIdLength = 16;
    protected static final String name = "ManagerBase";
    protected Random random = null;
    protected UuidGenerator uuidGenerator = new UuidGeneratorImpl();
    protected String randomClass = "java.security.SecureRandom";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected int expiredSessions = 0;
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected int sessionCounter = 0;
    protected volatile int maxActive = 0;
    protected final Object maxActiveUpdateLock = new Object();
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int rejectedSessions = 0;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator aUuidGenerator) {
        this.uuidGenerator = aUuidGenerator;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.getMaxInactiveIntervalSeconds();
    }

    public int getMaxInactiveIntervalSeconds() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.setMaxInactiveIntervalSeconds(interval);
    }

    public void setMaxInactiveIntervalSeconds(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", (Object)oldMaxInactiveInterval, (Object)this.maxInactiveInterval);
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", (Object)oldSessionIdLength, (Object)this.sessionIdLength);
    }

    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomFile(String s) {
        if (Globals.IS_SECURITY_ENABLED) {
            this.randomIS = AccessController.doPrivileged(new PrivilegedSetRandomFile());
        } else {
            FileInputStream fileInputStream = null;
            try {
                this.devRandomSource = s;
                File f = new File(this.devRandomSource);
                if (!f.exists()) {
                    return;
                }
                fileInputStream = new FileInputStream(f);
                this.randomIS = new DataInputStream(fileInputStream);
                this.randomIS.readLong();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Opening " + this.devRandomSource);
                }
            }
            catch (IOException ex) {
                this.randomIS = null;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this.random == null) {
            ManagerBase managerBase = this;
            synchronized (managerBase) {
                if (this.random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    for (int i = 0; i < entropy.length; ++i) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sm.getString("managerBase.random", this.randomClass), e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        this.log.fine(sm.getString("managerBase.seeding", this.randomClass) + " " + (t2 - t1));
                    }
                }
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    public int getExpiredSessions() {
        return this.expiredSessions;
    }

    public void setExpiredSessions(int expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public void setSessionLocker(SessionLocker sessLocker) {
        this.sessionLocker = sessLocker;
    }

    public void destroy() {
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.randomIS != null) {
            block4: {
                try {
                    this.randomIS.close();
                }
                catch (IOException ioe) {
                    if (!this.log.isLoggable(Level.WARNING)) break block4;
                    this.log.log(Level.WARNING, "Failed to close randomIS.");
                }
            }
            this.randomIS = null;
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                StandardContext ctx = (StandardContext)this.getContainer();
                this.domain = ctx.getEngineName();
                this.distributable = ctx.getDistributable();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getEncodedPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Error registering ", e);
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Registering " + this.oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.sessions.size();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Session createSession() {
        Session session = null;
        session = this.createEmptySession();
        session.lockForeground();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.generateSessionId(session);
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    public Session createSession(String sessionId) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        session.lockForeground();
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    public Session createEmptySession() {
        return this.getNewSession();
    }

    public void checkSessionAttribute(String name, Object value) {
        if (this.getDistributable() && !StandardSession.isSerializable(value)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae", name));
        }
    }

    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    public Session findSession(String id, HttpServletRequest request) throws IOException {
        return this.findSession(id);
    }

    public Session findSession(String id, String version) throws IOException {
        return this.findSession(id);
    }

    public boolean isSessionVersioningSupported() {
        return false;
    }

    public void clearSessions() {
        this.sessions.clear();
    }

    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    public void remove(Session session) {
        this.sessions.remove(session.getIdInternal());
    }

    public Cookie toCookie(Session session) throws IOException {
        return null;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void changeSessionId(Session session) {
        session.setId(this.generateSessionId());
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Got " + len + " " + bytes.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.devRandomSource = null;
            this.randomIS = null;
        }
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId(Object obj) {
        return this.uuidGenerator.generateUuid(obj);
    }

    protected synchronized String generateSessionId() {
        return this.generateSessionId(new Object());
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (!(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    protected void log(String message) {
        this.log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        this.log.log(Level.INFO, message, throwable);
    }

    public void setSessionCounter(int sessionCounter) {
        this.setSessionCount(sessionCounter);
    }

    public void setSessionCount(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public int getSessionCounter() {
        return this.getSessionCount();
    }

    public int getSessionCount() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int maxActive) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = maxActive;
        }
    }

    public int getSessionMaxAliveTime() {
        return this.getSessionMaxAliveTimeSeconds();
    }

    public int getSessionMaxAliveTimeSeconds() {
        return this.sessionMaxAliveTime;
    }

    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.setSessionMaxAliveTimeSeconds(sessionMaxAliveTime);
    }

    public void setSessionMaxAliveTimeSeconds(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    public int getSessionAverageAliveTime() {
        return this.getSessionAverageAliveTimeSeconds();
    }

    public int getSessionAverageAliveTimeSeconds() {
        return this.sessionAverageAliveTime;
    }

    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.setSessionAverageAliveTimeSeconds(sessionAverageAliveTime);
    }

    public void setSessionAverageAliveTimeSeconds(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    public String listSessionIds() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            this.log.info("Session not found " + sessionId);
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            this.log.info("Session not found " + sessionId);
            return;
        }
        s.expire();
    }

    public String getLastAccessedTimeMillis(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            this.log.info("Session not found " + sessionId);
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public void update(HttpSession session) throws Exception {
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void postRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
    }

    public void preRequestDispatcherProcess(ServletRequest request, ServletResponse response) {
    }

    public boolean lockSession(ServletRequest request) throws ServletException {
        boolean result = false;
        if (this.sessionLocker != null) {
            result = this.sessionLocker.lockSession(request);
        }
        return result;
    }

    public void unlockSession(ServletRequest request) {
        if (this.sessionLocker != null) {
            this.sessionLocker.unlockSession(request);
        }
    }

    public void release() {
        this.clearSessions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrivilegedSetRandomFile
    implements PrivilegedAction<DataInputStream> {
        private PrivilegedSetRandomFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataInputStream run() {
            DataInputStream dataInputStream;
            FileInputStream fileInputStream = null;
            try {
                File f = new File(ManagerBase.this.devRandomSource);
                if (!f.exists()) {
                    DataInputStream dataInputStream2 = null;
                    return dataInputStream2;
                }
                fileInputStream = new FileInputStream(f);
                ManagerBase.this.randomIS = new DataInputStream(fileInputStream);
                ManagerBase.this.randomIS.readLong();
                if (ManagerBase.this.log.isLoggable(Level.FINE)) {
                    ManagerBase.this.log.fine("Opening " + ManagerBase.this.devRandomSource);
                }
                dataInputStream = ManagerBase.this.randomIS;
            }
            catch (IOException ex) {
                DataInputStream dataInputStream3 = null;
                return dataInputStream3;
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException ex) {}
            }
            return dataInputStream;
        }
    }
}

