/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WAB
extends AbstractReadableArchive
implements ReadableArchive {
    private Bundle host;
    private Bundle[] fragments;
    private Map<String, ArchiveEntry> entries = new HashMap<String, ArchiveEntry>();
    private static final String LIB_DIR = "WEB-INF/lib/";
    private static final String JAR_EXT = ".jar";
    private static final String CLASSES_DIR = "WEB-INF/classes/";
    private static final String DOT = ".";
    private final Map<Bundle, OSGiBundleArchive> archives;

    public WAB(Bundle host, Bundle[] fragments) {
        this.host = host;
        this.fragments = fragments != null ? fragments : new Bundle[]{};
        this.archives = new HashMap<Bundle, OSGiBundleArchive>(this.fragments.length + 1);
        this.init();
    }

    private synchronized OSGiBundleArchive getArchive(Bundle b) {
        OSGiBundleArchive archive = this.archives.get(b);
        if (archive == null) {
            archive = new OSGiBundleArchive(b);
            this.archives.put(b, archive);
        }
        return archive;
    }

    private synchronized void init() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(Arrays.asList(this.fragments));
        bundles.add(0, this.host);
        for (Bundle b : bundles) {
            final OSGiBundleArchive archive = this.getArchive(b);
            for (final String entry : Collections.list(archive.entries())) {
                if (this.entries.containsKey(entry)) continue;
                ArchiveEntry archiveEntry = new ArchiveEntry(){

                    public String getName() {
                        return entry;
                    }

                    public URI getURI() throws URISyntaxException {
                        return archive.getEntryURI(entry);
                    }

                    public InputStream getInputStream() throws IOException {
                        return archive.getEntry(entry);
                    }
                };
                this.entries.put(entry, archiveEntry);
            }
        }
        EffectiveBCP bcp = this.getEffectiveBCP();
        bcp.accept(new BCPEntry.BCPEntryVisitor(){
            private int i = 0;

            public void visitDir(final DirBCPEntry bcpEntry) {
                try {
                    if (bcpEntry.getName().equals(WAB.CLASSES_DIR)) {
                        return;
                    }
                    ReadableArchive subArchive = WAB.this.getArchive(bcpEntry.getBundle()).getSubArchive(bcpEntry.getName());
                    for (final String subEntry : Collections.list(subArchive.entries())) {
                        ArchiveEntry archiveEntry = new ArchiveEntry(){

                            public String getName() {
                                return WAB.CLASSES_DIR + subEntry;
                            }

                            public URI getURI() throws URISyntaxException {
                                return bcpEntry.getBundle().getEntry(bcpEntry.getName() + subEntry).toURI();
                            }

                            public InputStream getInputStream() throws IOException {
                                try {
                                    return this.getURI().toURL().openStream();
                                }
                                catch (URISyntaxException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        };
                        WAB.this.entries.put(archiveEntry.getName(), archiveEntry);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void visitJar(final JarBCPEntry bcpEntry) {
                String newJarName;
                String jarName;
                if (bcpEntry.getName().startsWith(WAB.LIB_DIR) && bcpEntry.getName().endsWith(WAB.JAR_EXT) && (jarName = bcpEntry.getName().substring(WAB.LIB_DIR.length())).indexOf("/") == -1) {
                    return;
                }
                if (bcpEntry.getName().equals(WAB.DOT)) {
                    newJarName = "WEB-INF/lib/Bundle" + bcpEntry.getBundle().getBundleId() + WAB.JAR_EXT;
                    WAB.this.entries.put(newJarName, new ArchiveEntry(){

                        public String getName() {
                            return newJarName;
                        }

                        public URI getURI() throws URISyntaxException {
                            return WAB.this.getArchive(bcpEntry.getBundle()).getURI();
                        }

                        public InputStream getInputStream() throws IOException {
                            return WAB.this.getArchive(bcpEntry.getBundle()).getInputStream();
                        }
                    });
                } else {
                    newJarName = "WEB-INF/lib/Bundle" + bcpEntry.getBundle().getBundleId() + "-" + bcpEntry.getName().replace('/', '-') + WAB.JAR_EXT;
                    WAB.this.entries.put(newJarName, new ArchiveEntry(){

                        public String getName() {
                            return newJarName;
                        }

                        public URI getURI() throws URISyntaxException {
                            return bcpEntry.getBundle().getEntry(bcpEntry.getName()).toURI();
                        }

                        public InputStream getInputStream() throws IOException {
                            try {
                                return this.getURI().toURL().openStream();
                            }
                            catch (URISyntaxException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }
        });
    }

    private EffectiveBCP getEffectiveBCP() {
        EffectiveBCPBuilder builder = new EffectiveBCPBuilder();
        builder.createForHost();
        for (Bundle f : this.fragments) {
            builder.createForFragment(f);
        }
        return builder.build();
    }

    public InputStream getEntry(String name) throws IOException {
        ArchiveEntry archiveEntry = this.entries.get(name);
        return archiveEntry != null ? archiveEntry.getInputStream() : null;
    }

    public boolean exists(String name) throws IOException {
        return this.entries.containsKey(name);
    }

    public long getEntrySize(String name) {
        return 0L;
    }

    public void open(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        return null;
    }

    public boolean exists() {
        return true;
    }

    public boolean delete() {
        return false;
    }

    public boolean renameTo(String name) {
        return false;
    }

    public void setParentArchive(ReadableArchive parentArchive) {
        throw new UnsupportedOperationException();
    }

    public ReadableArchive getParentArchive() {
        return null;
    }

    public void close() throws IOException {
    }

    public Enumeration<String> entries() {
        final Enumeration<String> all = Collections.enumeration(this.entries.keySet());
        return new Enumeration<String>(){
            String next = this.getNext();

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String result = this.next;
                    this.next = this.getNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            private String getNext() {
                while (all.hasMoreElements()) {
                    String s = (String)all.nextElement();
                    if (s.endsWith("/")) continue;
                    return s;
                }
                return null;
            }
        };
    }

    public Enumeration<String> entries(final String prefix) {
        final Enumeration<String> all = this.entries();
        return new Enumeration<String>(){
            String next = this.getNext();

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String result = this.next;
                    this.next = this.getNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            private String getNext() {
                while (all.hasMoreElements()) {
                    String s = (String)all.nextElement();
                    if (!s.startsWith(prefix)) continue;
                    return s;
                }
                return null;
            }
        };
    }

    public Collection<String> getDirectories() throws IOException {
        ArrayList<String> dirEntries = new ArrayList<String>();
        Enumeration<String> all = this.entries();
        while (all.hasMoreElements()) {
            String s = all.nextElement();
            if (!s.endsWith("/")) continue;
            dirEntries.add(s);
        }
        return dirEntries;
    }

    public boolean isDirectory(String name) {
        return name.endsWith("/");
    }

    public Manifest getManifest() throws IOException {
        return new Manifest(this.getEntry("META-INF/MANIFEST.MF"));
    }

    public URI getURI() {
        return null;
    }

    public long getArchiveSize() throws SecurityException {
        return 0L;
    }

    public String getName() {
        return this.getArchive(this.host).getName();
    }

    class EffectiveBCPBuilder {
        private EffectiveBCP result;

        EffectiveBCPBuilder() {
            this.result = new EffectiveBCP();
        }

        public EffectiveBCP build() {
            return this.result;
        }

        void createForHost() {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>(Arrays.asList(WAB.this.fragments));
            bundles.add(0, WAB.this.host);
            for (String s : this.tokenizeBCP(WAB.this.host)) {
                for (Bundle b : bundles) {
                    OSGiBundleArchive archive = WAB.this.getArchive(b);
                    if (!archive.exists(s)) continue;
                    if (archive.isDirectory(s)) {
                        this.result.add(this.createDirBCPEntry(s, b));
                        continue;
                    }
                    this.result.add(this.createJarBCPEntry(s, b));
                }
            }
        }

        void createForFragment(Bundle bundle) {
            for (String s : this.tokenizeBCP(bundle)) {
                OSGiBundleArchive archive = WAB.this.getArchive(bundle);
                if (WAB.DOT.equals(s)) {
                    this.result.add(this.createJarBCPEntry(WAB.DOT, bundle));
                    continue;
                }
                if (!archive.exists(s)) continue;
                if (archive.isDirectory(s)) {
                    this.result.add(this.createDirBCPEntry(s, bundle));
                    continue;
                }
                this.result.add(this.createJarBCPEntry(s, bundle));
            }
        }

        private JarBCPEntry createJarBCPEntry(String entryPath, Bundle bundle) {
            return new JarBCPEntry(entryPath, bundle);
        }

        private DirBCPEntry createDirBCPEntry(String entryPath, Bundle bundle) {
            return new DirBCPEntry(entryPath, bundle);
        }

        private String[] tokenizeBCP(Bundle b) {
            String bcp = (String)b.getHeaders().get("Bundle-ClassPath");
            if (bcp == null || bcp.isEmpty()) {
                bcp = WAB.DOT;
            }
            return bcp.split(";|,");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EffectiveBCP {
        private List<BCPEntry> bcpEntries = new ArrayList<BCPEntry>();

        EffectiveBCP() {
        }

        public List<BCPEntry> getBCPEntries() {
            return this.bcpEntries;
        }

        public void accept(BCPEntry.BCPEntryVisitor visitor) {
            for (BCPEntry bcpEntry : this.getBCPEntries()) {
                bcpEntry.accept(visitor);
            }
        }

        public void add(BCPEntry bcpEntry) {
            this.bcpEntries.add(bcpEntry);
        }
    }

    class JarBCPEntry
    implements BCPEntry {
        private String name;
        private Bundle bundle;

        public JarBCPEntry(String name, Bundle bundle) {
            this.name = name;
            this.bundle = bundle;
        }

        public String getName() {
            return this.name;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void accept(BCPEntry.BCPEntryVisitor visitor) {
            visitor.visitJar(this);
        }
    }

    class DirBCPEntry
    implements BCPEntry {
        private String name;
        private Bundle bundle;

        public DirBCPEntry(String name, Bundle bundle) {
            this.name = name;
            this.bundle = bundle;
        }

        public String getName() {
            return this.name;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void accept(BCPEntry.BCPEntryVisitor visitor) {
            visitor.visitDir(this);
        }
    }

    static interface BCPEntry {
        public String getName();

        public Bundle getBundle();

        public void accept(BCPEntryVisitor var1);

        public static interface BCPEntryVisitor {
            public void visitDir(DirBCPEntry var1);

            public void visitJar(JarBCPEntry var1);
        }
    }

    static interface ArchiveEntry {
        public String getName();

        public URI getURI() throws URISyntaxException;

        public InputStream getInputStream() throws IOException;
    }
}

